/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool.jdbc;

import com.wlyk.carpark.dbtool.jdbc.PersistenceException;
import com.wlyk.carpark.dbtool.jdbc.ResultRowCallBack;
import com.wlyk.carpark.dbtool.jdbc.io.Resources;
import com.wlyk.carpark.dbtool.jdbc.reflection.DefaultObjectFactory;
import com.wlyk.carpark.dbtool.jdbc.reflection.DefaultObjectWrapperFactory;
import com.wlyk.carpark.dbtool.jdbc.reflection.MetaObject;
import com.wlyk.carpark.dbtool.jdbc.reflection.ObjectFactory;
import com.wlyk.carpark.dbtool.jdbc.reflection.ObjectWrapperFactory;
import com.wlyk.carpark.dbtool.jdbc.type.JdbcType;
import com.wlyk.carpark.dbtool.jdbc.type.Null;
import com.wlyk.carpark.dbtool.jdbc.type.ObjectTypeHandler;
import com.wlyk.carpark.dbtool.jdbc.type.TypeHandler;
import com.wlyk.carpark.dbtool.jdbc.type.TypeHandlerRegistry;
import com.wlyk.carpark.dbtool.jdbc.type.UnknownTypeHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JdbcTool {
    private static ObjectFactory objectFactory = new DefaultObjectFactory();
    private static ObjectWrapperFactory objectWrapperFactory = new DefaultObjectWrapperFactory();
    private static TypeHandlerRegistry typeHandlerRegistry = new TypeHandlerRegistry();

    public static void setObjectFactory(ObjectFactory objectFactory) {
        JdbcTool.objectFactory = objectFactory;
    }

    public static void setObjectWrapperFactory(ObjectWrapperFactory objectWrapperFactory) {
        JdbcTool.objectWrapperFactory = objectWrapperFactory;
    }

    public static void setTypeHandlerRegistry(TypeHandlerRegistry typeHandlerRegistry) {
        JdbcTool.typeHandlerRegistry = typeHandlerRegistry;
    }

    public static void setParameters(PreparedStatement ps, Object ... args) throws SQLException {
        int i = 0;
        int n = args.length;
        while (i < n) {
            if (args[i] == null) {
                throw new SQLException("JdbcTool requires an instance of Null to represent typed null values for JDBC compatibility");
            }
            if (args[i] instanceof Null) {
                ((Null)((Object)args[i])).getTypeHandler().setParameter(ps, i + 1, null, ((Null)((Object)args[i])).getJdbcType());
            } else {
                TypeHandler<?> typeHandler = typeHandlerRegistry.getTypeHandler(args[i].getClass());
                if (typeHandler == null) {
                    throw new SQLException("JdbcTool could not find a TypeHandler instance for " + args[i].getClass());
                }
                typeHandler.setParameter(ps, i + 1, args[i], null);
            }
            ++i;
        }
    }

    public static void handleResultSet(ResultSet rs, ResultRowCallBack rowCallback) throws Exception {
        if (rowCallback.isCallNextRow()) {
            ResultSetMetaData metaData = null;
            int columnCount = 0;
            ArrayList<String> columns = null;
            ArrayList<String> classNames = null;
            ArrayList<JdbcType> jdbcTypes = null;
            Class rowClass = rowCallback.getRowClassType();
            if (!ResultSet.class.equals(rowClass)) {
                metaData = rs.getMetaData();
                columnCount = metaData.getColumnCount();
                columns = new ArrayList<String>(columnCount);
                classNames = new ArrayList<String>(columnCount);
                jdbcTypes = new ArrayList<JdbcType>(columnCount);
                JdbcTool.readFromMetaData(metaData, columns, classNames, jdbcTypes);
            }
            while (rs.next()) {
                ResultSet row;
                if (ResultSet.class.equals(rowClass)) {
                    row = rs;
                } else {
                    String columnName;
                    int i;
                    if (metaData == null) {
                        metaData = rs.getMetaData();
                        columnCount = metaData.getColumnCount();
                        columns = new ArrayList(columnCount);
                        classNames = new ArrayList(columnCount);
                        jdbcTypes = new ArrayList(columnCount);
                        JdbcTool.readFromMetaData(metaData, columns, classNames, jdbcTypes);
                    }
                    if ((row = objectFactory.create(rowClass)) instanceof Map) {
                        Map map = (Map)((Object)row);
                        i = 0;
                        while (i < columnCount) {
                            columnName = columns.get(i);
                            TypeHandler<?> typeHandler = JdbcTool.getResultTypeHandler(null, i, classNames, jdbcTypes);
                            Object value = typeHandler.getResult(rs, columnName);
                            try {
                                map.put(columnName, value);
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            ++i;
                        }
                    } else {
                        MetaObject metaObject = MetaObject.forObject(row, objectFactory, objectWrapperFactory);
                        i = 0;
                        while (i < columnCount) {
                            TypeHandler<?> typeHandler;
                            Object value;
                            Class<?> propertyType;
                            columnName = columns.get(i);
                            String property = metaObject.findProperty(columnName, rowCallback.isUseCamelCaseMapping());
                            if (property != null && typeHandlerRegistry.hasTypeHandler(propertyType = metaObject.getSetterType(property)) && (value = (typeHandler = JdbcTool.getResultTypeHandler(propertyType, i, classNames, jdbcTypes)).getResult(rs, columnName)) != null) {
                                metaObject.setValue(property, value);
                            }
                            ++i;
                        }
                    }
                }
                if (row != null) {
                    rowCallback.call(row);
                }
                if (!rowCallback.isCallNextRow()) break;
                rowClass = rowCallback.getRowClassType();
            }
        }
    }

    private static void readFromMetaData(ResultSetMetaData metaData, List<String> columns, List<String> classNames, List<JdbcType> jdbcTypes) throws SQLException {
        int columnCount = metaData.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            columns.add(metaData.getColumnLabel(i));
            jdbcTypes.add(JdbcType.forCode(metaData.getColumnType(i)));
            classNames.add(metaData.getColumnClassName(i));
            ++i;
        }
    }

    private static Class<?> resolveClass(String className) {
        try {
            Class<?> clazz = Resources.classForName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static TypeHandler<?> getResultTypeHandler(Class<?> propertyType, int columnNameIndex, List<String> classNames, List<JdbcType> jdbcTypes) {
        TypeHandler<Object> handler = null;
        handler = typeHandlerRegistry.getTypeHandler(propertyType);
        if (handler == null || handler instanceof UnknownTypeHandler) {
            JdbcType jdbcType = jdbcTypes.get(columnNameIndex);
            Class<?> javaType = JdbcTool.resolveClass(classNames.get(columnNameIndex));
            if (javaType != null && jdbcType != null) {
                handler = typeHandlerRegistry.getTypeHandler(javaType, jdbcType);
            } else if (javaType != null) {
                handler = typeHandlerRegistry.getTypeHandler(javaType);
            } else if (jdbcType != null) {
                handler = typeHandlerRegistry.getTypeHandler(jdbcType);
            }
        }
        if (handler == null || handler instanceof UnknownTypeHandler) {
            handler = new ObjectTypeHandler();
        }
        return handler;
    }

    public static void closeResultSet(ResultSet rs) throws PersistenceException {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenceException("close ResultSet error!", e);
        }
    }

    public static void closeStatement(Statement st) throws PersistenceException {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenceException("close Statement error!", e);
        }
    }

    public static void closeConnection(Connection conn) throws PersistenceException {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenceException("close Connection error!", e);
        }
    }
}

