/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool.jdbc.io;

import com.wlyk.carpark.dbtool.jdbc.io.ResolverUtil;
import com.wlyk.carpark.dbtool.jdbc.io.VFS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultVFS
extends VFS {
    private static final Logger logger = Logger.getLogger(ResolverUtil.class.getName());
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public List<String> list(URL url, String path) throws IOException {
        InputStream is = null;
        try {
            ArrayList<String> resources = new ArrayList();
            URL jarUrl = this.findJarForResource(url);
            if (jarUrl != null) {
                is = jarUrl.openStream();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Listing " + url);
                }
                resources = this.listResources(new JarInputStream(is), path);
            } else {
                String prefix;
                List<Object> children;
                block30: {
                    children = new ArrayList<String>();
                    try {
                        String line;
                        if (this.isJar(url)) {
                            is = url.openStream();
                            try (JarInputStream jarInput = new JarInputStream(is);){
                                JarEntry jarEntry;
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Listing " + url);
                                }
                                while ((jarEntry = jarInput.getNextJarEntry()) != null) {
                                    if (logger.isLoggable(Level.FINEST)) {
                                        logger.finest("Jar entry: " + jarEntry.getName());
                                    }
                                    children.add(jarEntry.getName());
                                }
                                break block30;
                            }
                        }
                        is = url.openStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Reader entry: " + line);
                            }
                            arrayList.add(line);
                            if (!DefaultVFS.getResources(String.valueOf(path) + "/" + line).isEmpty()) continue;
                            arrayList.clear();
                            break;
                        }
                        if (!arrayList.isEmpty()) {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Listing " + url);
                            }
                            children.addAll(arrayList);
                        }
                    }
                    catch (FileNotFoundException e) {
                        if ("file".equals(url.getProtocol())) {
                            File file = new File(url.getFile());
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Listing directory " + file.getAbsolutePath());
                            }
                            if (file.isDirectory()) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Listing " + url);
                                }
                                children = Arrays.asList(file.list());
                            }
                        }
                        throw e;
                    }
                }
                if (!(prefix = url.toExternalForm()).endsWith("/")) {
                    prefix = String.valueOf(prefix) + "/";
                }
                for (String string : children) {
                    String resourcePath = String.valueOf(path) + "/" + string;
                    resources.add(resourcePath);
                    URL childUrl = new URL(String.valueOf(prefix) + string);
                    resources.addAll(this.list(childUrl, resourcePath));
                }
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected List<String> listResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            if (!name.startsWith(path)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Found resource: " + name);
            }
            resources.add(name.substring(1));
        }
        return resources;
    }

    protected URL findJarForResource(URL url) throws MalformedURLException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Find JAR URL: " + url);
        }
        try {
            while (true) {
                url = new URL(url.getFile());
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Inner URL: " + url);
            }
        }
        catch (MalformedURLException malformedURLException) {
            StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
            int index = jarUrl.lastIndexOf(".jar");
            if (index >= 0) {
                jarUrl.setLength(index + 4);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Extracted JAR URL: " + jarUrl);
                }
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Not a JAR: " + jarUrl);
                }
                return null;
            }
            try {
                URL testUrl = new URL(jarUrl.toString());
                if (this.isJar(testUrl)) {
                    return testUrl;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Not a JAR: " + jarUrl);
                }
                jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
                File file = new File(jarUrl.toString());
                if (!file.exists()) {
                    try {
                        file = new File(URLEncoder.encode(jarUrl.toString(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
                    }
                }
                if (file.exists()) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Trying real file: " + file.getAbsolutePath());
                    }
                    if (this.isJar(testUrl = file.toURI().toURL())) {
                        return testUrl;
                    }
                }
            }
            catch (MalformedURLException e) {
                logger.warning("Invalid JAR URL: " + jarUrl);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Not a JAR: " + jarUrl);
            }
            return null;
        }
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    protected boolean isJar(URL url, byte[] buffer) {
        InputStream is = null;
        try {
            is = url.openStream();
            is.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Found JAR: " + url);
                }
                return true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

