/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool.jdbc.reflection;

import com.wlyk.carpark.dbtool.jdbc.reflection.GetFieldInvoker;
import com.wlyk.carpark.dbtool.jdbc.reflection.Invoker;
import com.wlyk.carpark.dbtool.jdbc.reflection.MethodInvoker;
import com.wlyk.carpark.dbtool.jdbc.reflection.PropertyTokenizer;
import com.wlyk.carpark.dbtool.jdbc.reflection.Reflector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class MetaClass {
    private Reflector reflector;

    private MetaClass(Class<?> type) {
        this.reflector = Reflector.forClass(type);
    }

    public static MetaClass forClass(Class<?> type) {
        return new MetaClass(type);
    }

    public static boolean isClassCacheEnabled() {
        return Reflector.isClassCacheEnabled();
    }

    public static void setClassCacheEnabled(boolean classCacheEnabled) {
        Reflector.setClassCacheEnabled(classCacheEnabled);
    }

    public MetaClass metaClassForProperty(String name) {
        Class<?> propType = this.reflector.getGetterType(name);
        return MetaClass.forClass(propType);
    }

    public String findProperty(String name) {
        StringBuilder prop = this.buildProperty(name, new StringBuilder());
        return prop.length() > 0 ? prop.toString() : null;
    }

    public String[] getGetterNames() {
        return this.reflector.getGetablePropertyNames();
    }

    public String[] getSetterNames() {
        return this.reflector.getSetablePropertyNames();
    }

    public Class<?> getSetterType(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaClass metaProp = this.metaClassForProperty(prop.getName());
            return metaProp.getSetterType(prop.getChildren());
        }
        return this.reflector.getSetterType(prop.getName());
    }

    public Class<?> getGetterType(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaClass metaProp = this.metaClassForProperty(prop);
            return metaProp.getGetterType(prop.getChildren());
        }
        return this.getGetterType(prop);
    }

    private MetaClass metaClassForProperty(PropertyTokenizer prop) {
        Class<?> propType = this.getGetterType(prop);
        return MetaClass.forClass(propType);
    }

    private Class<?> getGetterType(PropertyTokenizer prop) {
        Type[] actualTypeArguments;
        Type returnType;
        Class type = this.reflector.getGetterType(prop.getName());
        if (prop.getIndex() != null && Collection.class.isAssignableFrom(type) && (returnType = this.getGenericGetterType(prop.getName())) instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)returnType).getActualTypeArguments()) != null && actualTypeArguments.length == 1) {
            returnType = actualTypeArguments[0];
            if (returnType instanceof Class) {
                type = (Class)returnType;
            } else if (returnType instanceof ParameterizedType) {
                type = (Class)((ParameterizedType)returnType).getRawType();
            }
        }
        return type;
    }

    private Type getGenericGetterType(String propertyName) {
        try {
            Invoker invoker = this.reflector.getGetInvoker(propertyName);
            if (invoker instanceof MethodInvoker) {
                Field _method = MethodInvoker.class.getDeclaredField("method");
                _method.setAccessible(true);
                Method method = (Method)_method.get(invoker);
                return method.getGenericReturnType();
            }
            if (invoker instanceof GetFieldInvoker) {
                Field _field = GetFieldInvoker.class.getDeclaredField("field");
                _field.setAccessible(true);
                Field field = (Field)_field.get(invoker);
                return field.getGenericType();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasSetter(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            if (this.reflector.hasSetter(prop.getName())) {
                MetaClass metaProp = this.metaClassForProperty(prop.getName());
                return metaProp.hasSetter(prop.getChildren());
            }
            return false;
        }
        return this.reflector.hasSetter(prop.getName());
    }

    public boolean hasGetter(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            if (this.reflector.hasGetter(prop.getName())) {
                MetaClass metaProp = this.metaClassForProperty(prop);
                return metaProp.hasGetter(prop.getChildren());
            }
            return false;
        }
        return this.reflector.hasGetter(prop.getName());
    }

    public Invoker getGetInvoker(String name) {
        return this.reflector.getGetInvoker(name);
    }

    public Invoker getSetInvoker(String name) {
        return this.reflector.getSetInvoker(name);
    }

    private StringBuilder buildProperty(String name, StringBuilder builder) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            String propertyName = this.reflector.findPropertyName(prop.getName());
            if (propertyName != null) {
                builder.append(propertyName);
                builder.append(".");
                MetaClass metaProp = this.metaClassForProperty(propertyName);
                metaProp.buildProperty(prop.getChildren(), builder);
            }
        } else {
            String propertyName = this.reflector.findPropertyName(name);
            if (propertyName != null) {
                builder.append(propertyName);
            }
        }
        return builder;
    }
}

