/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool.jdbc.reflection;

import com.wlyk.carpark.dbtool.jdbc.reflection.GetFieldInvoker;
import com.wlyk.carpark.dbtool.jdbc.reflection.Invoker;
import com.wlyk.carpark.dbtool.jdbc.reflection.MethodInvoker;
import com.wlyk.carpark.dbtool.jdbc.reflection.PropertyNamer;
import com.wlyk.carpark.dbtool.jdbc.reflection.ReflectionException;
import com.wlyk.carpark.dbtool.jdbc.reflection.SetFieldInvoker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Reflector {
    private static boolean classCacheEnabled = true;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Map<Class<?>, Reflector> REFLECTOR_MAP = new ConcurrentHashMap();
    private Class<?> type;
    private String[] readablePropertyNames = EMPTY_STRING_ARRAY;
    private String[] writeablePropertyNames = EMPTY_STRING_ARRAY;
    private Map<String, Invoker> setMethods = new HashMap<String, Invoker>();
    private Map<String, Invoker> getMethods = new HashMap<String, Invoker>();
    private Map<String, Class<?>> setTypes = new HashMap();
    private Map<String, Class<?>> getTypes = new HashMap();
    private Constructor<?> defaultConstructor;
    private Map<String, String> caseInsensitivePropertyMap = new HashMap<String, String>();

    private Reflector(Class<?> clazz) {
        String propName;
        this.type = clazz;
        this.addDefaultConstructor(clazz);
        this.addGetMethods(clazz);
        this.addSetMethods(clazz);
        this.addFields(clazz);
        this.readablePropertyNames = this.getMethods.keySet().toArray(new String[this.getMethods.keySet().size()]);
        this.writeablePropertyNames = this.setMethods.keySet().toArray(new String[this.setMethods.keySet().size()]);
        String[] stringArray = this.readablePropertyNames;
        int n = this.readablePropertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            propName = stringArray[n2];
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
            ++n2;
        }
        stringArray = this.writeablePropertyNames;
        n = this.writeablePropertyNames.length;
        n2 = 0;
        while (n2 < n) {
            propName = stringArray[n2];
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
            ++n2;
        }
    }

    private void addDefaultConstructor(Class<?> clazz) {
        Constructor<?>[] consts;
        Constructor<?>[] constructorArray = consts = clazz.getDeclaredConstructors();
        int n = consts.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (constructor.getParameterTypes().length == 0) {
                if (Reflector.canAccessPrivateMethods()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (constructor.isAccessible()) {
                    this.defaultConstructor = constructor;
                }
            }
            ++n2;
        }
    }

    private void addGetMethods(Class<?> cls) {
        Method[] methods;
        Method[] methodArray = methods = this.getClassMethods(cls);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3) {
                if (method.getParameterTypes().length == 0) {
                    name = PropertyNamer.methodToProperty(name);
                    this.addGetMethod(name, method);
                }
            } else if (name.startsWith("is") && name.length() > 2 && method.getParameterTypes().length == 0) {
                name = PropertyNamer.methodToProperty(name);
                this.addGetMethod(name, method);
            }
            ++n2;
        }
    }

    private void addGetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.getMethods.put(name, new MethodInvoker(method));
            this.getTypes.put(name, method.getReturnType());
        }
    }

    private void addSetMethods(Class<?> cls) {
        Method[] methods;
        HashMap<String, List<Method>> conflictingSetters = new HashMap<String, List<Method>>();
        Method[] methodArray = methods = this.getClassMethods(cls);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            if (name.startsWith("set") && name.length() > 3 && method.getParameterTypes().length == 1) {
                name = PropertyNamer.methodToProperty(name);
                this.addSetterConflict(conflictingSetters, name, method);
            }
            ++n2;
        }
        this.resolveSetterConflicts(conflictingSetters);
    }

    private void addSetterConflict(Map<String, List<Method>> conflictingSetters, String name, Method method) {
        List<Method> list = conflictingSetters.get(name);
        if (list == null) {
            list = new ArrayList<Method>();
            conflictingSetters.put(name, list);
        }
        list.add(method);
    }

    private void resolveSetterConflicts(Map<String, List<Method>> conflictingSetters) {
        for (String propName : conflictingSetters.keySet()) {
            List<Method> setters = conflictingSetters.get(propName);
            Method firstMethod = setters.get(0);
            if (setters.size() == 1) {
                this.addSetMethod(propName, firstMethod);
                continue;
            }
            Class<?> expectedType = this.getTypes.get(propName);
            if (expectedType == null) {
                throw new ReflectionException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            Iterator<Method> methods = setters.iterator();
            Method setter = null;
            while (methods.hasNext()) {
                Method method = methods.next();
                if (method.getParameterTypes().length != 1 || !expectedType.equals(method.getParameterTypes()[0])) continue;
                setter = method;
                break;
            }
            if (setter == null) {
                throw new ReflectionException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            this.addSetMethod(propName, setter);
        }
    }

    private void addSetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.setMethods.put(name, new MethodInvoker(method));
            this.setTypes.put(name, method.getParameterTypes()[0]);
        }
    }

    private void addFields(Class<?> clazz) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Reflector.canAccessPrivateMethods()) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (field.isAccessible()) {
                if (!this.setMethods.containsKey(field.getName())) {
                    this.addSetField(field);
                }
                if (!this.getMethods.containsKey(field.getName())) {
                    this.addGetField(field);
                }
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            this.addFields(clazz.getSuperclass());
        }
    }

    private void addSetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.setMethods.put(field.getName(), new SetFieldInvoker(field));
            this.setTypes.put(field.getName(), field.getType());
        }
    }

    private void addGetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.getMethods.put(field.getName(), new GetFieldInvoker(field));
            this.getTypes.put(field.getName(), field.getType());
        }
    }

    private boolean isValidPropertyName(String name) {
        return !name.startsWith("$") && !"serialVersionUID".equals(name) && !"class".equals(name);
    }

    private Method[] getClassMethods(Class<?> cls) {
        HashMap<String, Method> uniqueMethods = new HashMap<String, Method>();
        Class<?> currentClass = cls;
        while (currentClass != null) {
            Class<?>[] interfaces;
            this.addUniqueMethods(uniqueMethods, currentClass.getDeclaredMethods());
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> anInterface = classArray[n2];
                this.addUniqueMethods(uniqueMethods, anInterface.getMethods());
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        Collection methods = uniqueMethods.values();
        return methods.toArray(new Method[methods.size()]);
    }

    private void addUniqueMethods(HashMap<String, Method> uniqueMethods, Method[] methods) {
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String signature;
            Method currentMethod = methodArray[n2];
            if (!currentMethod.isBridge() && !uniqueMethods.containsKey(signature = this.getSignature(currentMethod))) {
                if (Reflector.canAccessPrivateMethods()) {
                    try {
                        currentMethod.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                uniqueMethods.put(signature, currentMethod);
            }
            ++n2;
        }
    }

    private String getSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        int i = 0;
        while (i < parameters.length) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
            ++i;
        }
        return sb.toString();
    }

    private static boolean canAccessPrivateMethods() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Constructor<?> getDefaultConstructor() {
        if (this.defaultConstructor != null) {
            return this.defaultConstructor;
        }
        throw new ReflectionException("There is no default constructor for " + this.type);
    }

    public Invoker getSetInvoker(String propertyName) {
        Invoker method = this.setMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Invoker getGetInvoker(String propertyName) {
        Invoker method = this.getMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Class<?> getSetterType(String propertyName) {
        Class<?> clazz = this.setTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public Class<?> getGetterType(String propertyName) {
        Class<?> clazz = this.getTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public String[] getGetablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getSetablePropertyNames() {
        return this.writeablePropertyNames;
    }

    public boolean hasSetter(String propertyName) {
        return this.setMethods.keySet().contains(propertyName);
    }

    public boolean hasGetter(String propertyName) {
        return this.getMethods.keySet().contains(propertyName);
    }

    public String findPropertyName(String name) {
        return this.caseInsensitivePropertyMap.get(name.toUpperCase(Locale.ENGLISH));
    }

    public static Reflector forClass(Class<?> clazz) {
        if (classCacheEnabled) {
            Reflector cached = REFLECTOR_MAP.get(clazz);
            if (cached == null) {
                cached = new Reflector(clazz);
                REFLECTOR_MAP.put(clazz, cached);
            }
            return cached;
        }
        return new Reflector(clazz);
    }

    public static void setClassCacheEnabled(boolean classCacheEnabled) {
        Reflector.classCacheEnabled = classCacheEnabled;
    }

    public static boolean isClassCacheEnabled() {
        return classCacheEnabled;
    }
}

