
-- version 1 cs
CREATE TABLE IF NOT EXISTS ck_cloud_ddl_sync_log(
	id bigint NOT NULL,
	table_name varchar(64) NOT NULL,
	pk_value bigint NOT NULL,
	op_type char(1) NOT NULL,
	op_time timestamp NOT NULL,
	op_service varchar(100) NOT NULL,
	PRIMARY KEY (id)
);

-- version 2 cs
CREATE SEQUENCE ck_cloud_ddl_sync_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 3 cs $$;
CREATE OR REPLACE FUNCTION ck_cloud_ddl_sync_log_trigger() RETURNS trigger LANGUAGE plpgsql AS $$
     DECLARE
     d_newlogid ck_cloud_ddl_sync_log.id%TYPE;
     d_table_name ck_cloud_ddl_sync_log.table_name%TYPE;
     d_id_value ck_cloud_ddl_sync_log.pk_value%TYPE;
     d_optype ck_cloud_ddl_sync_log.op_type%TYPE;
     d_op_time ck_cloud_ddl_sync_log.op_time%TYPE;
     op_service ck_cloud_ddl_sync_log.op_service%TYPE;
     BEGIN 
	    d_table_name := TG_RELNAME;
	    d_optype := NULL;
        IF TG_OP = 'DELETE' THEN
            d_optype :='D';
            d_id_value :=OLD.id;
        ELSIF TG_OP = 'UPDATE' THEN
            d_optype :='U';
            d_id_value :=NEW.id;
        ELSIF TG_OP = 'INSERT' THEN
            d_optype :='I';
            d_id_value :=NEW.id;
        END IF;
        IF (d_optype IS NOT NULL) THEN
          d_newlogid :=nextval('ck_cloud_ddl_sync_log_seq');
          d_op_time :=now();
          op_service :='cloudSyncDataService';
          INSERT INTO ck_cloud_ddl_sync_log (id,table_name,pk_value,op_type,op_time,op_service) VALUES (d_newlogid,d_table_name,d_id_value,d_optype,d_op_time,op_service);
        END IF;
    RETURN NULL;
    END;
$$;

-- version 4 cs
CREATE SEQUENCE ck_cloud_common_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 5 cs
CREATE TABLE IF NOT EXISTS ck_cloud_upload_pic(
	id bigint NOT NULL,
	pic_path varchar(200) NOT NULL,
	upload_time timestamp NOT NULL,
	PRIMARY KEY (id)
);

-- version 6 cs
CREATE INDEX ck_cloud_upload_pic_index_001 ON ck_cloud_upload_pic (pic_path);

-- version 7 cs
DROP TRIGGER IF EXISTS ck_carpark_host_sync_cloud_trigger ON ck_carpark_host_sync;

-- version 8 cs
CREATE TRIGGER ck_carpark_host_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_host_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 9 cs
DROP TRIGGER IF EXISTS ck_carpark_user_sync_cloud_trigger ON ck_carpark_user_sync;

-- version 10 cs
CREATE TRIGGER ck_carpark_user_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_user_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 11 cs
DROP TRIGGER IF EXISTS ck_carpark_role_sync_cloud_trigger ON ck_carpark_role_sync;

-- version 12 cs
CREATE TRIGGER ck_carpark_role_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_role_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 13 cs
DROP TRIGGER IF EXISTS ck_carpark_role_permission_sync_cloud_trigger ON ck_carpark_role_permission_sync;

-- version 14 cs
CREATE TRIGGER ck_carpark_role_permission_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_role_permission_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 15 cs
DROP TRIGGER IF EXISTS ck_carpark_area_sync_cloud_trigger ON ck_carpark_area_sync;

-- version 16 cs
CREATE TRIGGER ck_carpark_area_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_area_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 17 cs
DROP TRIGGER IF EXISTS ck_carpark_channel_sync_cloud_trigger ON ck_carpark_channel_sync;

-- version 18 cs
CREATE TRIGGER ck_carpark_channel_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_channel_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 19 cs
DROP TRIGGER IF EXISTS ck_carpark_channel_area_sync_cloud_trigger ON ck_carpark_channel_area_sync;

-- version 20 cs 
CREATE TRIGGER ck_carpark_channel_area_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_channel_area_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 21 cs
DROP TRIGGER IF EXISTS ck_carpark_equipment_sync_cloud_trigger ON ck_carpark_equipment_sync;

-- version 22 cs
CREATE TRIGGER ck_carpark_equipment_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_equipment_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 23 cs
DROP TRIGGER IF EXISTS ck_carpark_equipment_config_sync_cloud_trigger ON ck_carpark_equipment_config_sync;

-- version 24 cs
CREATE TRIGGER ck_carpark_equipment_config_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_equipment_config_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 25 cs
DROP TRIGGER IF EXISTS ck_carpark_channel_equipment_sync_cloud_trigger ON ck_carpark_channel_equipment_sync;

-- version 26 cs
CREATE TRIGGER ck_carpark_channel_equipment_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_channel_equipment_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 27 cs
DROP TRIGGER IF EXISTS ck_carpark_passport_type_sync_cloud_trigger ON ck_carpark_passport_type_sync;

-- version 28 cs
CREATE TRIGGER ck_carpark_passport_type_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_passport_type_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 29 cs
DROP TRIGGER IF EXISTS ck_carpark_car_type_sync_cloud_trigger ON ck_carpark_car_type_sync;

-- version 30 cs
CREATE TRIGGER ck_carpark_car_type_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_car_type_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 31 cs
DROP TRIGGER IF EXISTS ck_carpark_attribute_sync_cloud_trigger ON ck_carpark_attribute_sync;

-- version 32 cs 
CREATE TRIGGER ck_carpark_attribute_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_attribute_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 33 cs
DROP TRIGGER IF EXISTS ck_carpark_strategy_sync_cloud_trigger ON ck_carpark_strategy_sync;

-- version 34 cs 
CREATE TRIGGER ck_carpark_strategy_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_strategy_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 35 cs
DROP TRIGGER IF EXISTS ck_carpark_special_date_sync_cloud_trigger ON ck_carpark_special_date_sync;

-- version 36 cs 
CREATE TRIGGER ck_carpark_special_date_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_special_date_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 37 cs
DROP TRIGGER IF EXISTS ck_carpark_space_type_sync_cloud_trigger ON ck_carpark_space_type_sync;

-- version 38 cs
CREATE TRIGGER ck_carpark_space_type_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_space_type_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 39 cs
DROP TRIGGER IF EXISTS ck_carpark_space_type_define_sync_cloud_trigger ON ck_carpark_space_type_define_sync;

-- version 40 cs
CREATE TRIGGER ck_carpark_space_type_define_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_space_type_define_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 41 cs
DROP TRIGGER IF EXISTS ck_carpark_space_type_quantity_sync_cloud_trigger ON ck_carpark_space_type_quantity_sync;

-- version 42 cs
CREATE TRIGGER ck_carpark_space_type_quantity_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_space_type_quantity_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 43 cs
DROP TRIGGER IF EXISTS ck_carpark_pass_permission_sync_cloud_trigger ON ck_carpark_pass_permission_sync;

-- version 44 cs
CREATE TRIGGER ck_carpark_pass_permission_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_pass_permission_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 45 cs
DROP TRIGGER IF EXISTS ck_carpark_date_range_sync_cloud_trigger ON ck_carpark_date_range_sync;

-- version 46 cs
CREATE TRIGGER ck_carpark_date_range_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_date_range_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 47 cs
DROP TRIGGER IF EXISTS ck_carpark_pass_permission_channel_sync_cloud_trigger ON ck_carpark_pass_permission_channel_sync;

-- version 48 cs
CREATE TRIGGER ck_carpark_pass_permission_channel_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_pass_permission_channel_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 49 cs
DROP TRIGGER IF EXISTS ck_carpark_recharge_rule_sync_cloud_trigger ON ck_carpark_recharge_rule_sync;

-- version 50 cs
CREATE TRIGGER ck_carpark_recharge_rule_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_recharge_rule_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 51 cs
DROP TRIGGER IF EXISTS ck_carpark_charge_rule_sync_cloud_trigger ON ck_carpark_charge_rule_sync;

-- version 52 cs
CREATE TRIGGER ck_carpark_charge_rule_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_charge_rule_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 53 cs
DROP TRIGGER IF EXISTS ck_carpark_charge_segment_rule_sync_cloud_trigger ON ck_carpark_charge_segment_rule_sync;

-- version 54 cs
CREATE TRIGGER ck_carpark_charge_segment_rule_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_charge_segment_rule_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 55 cs
DROP TRIGGER IF EXISTS ck_carpark_charge_time_len_range_sync_cloud_trigger ON ck_carpark_charge_time_len_range_sync;

-- version 56 cs
CREATE TRIGGER ck_carpark_charge_time_len_range_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_charge_time_len_range_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 57 cs
DROP TRIGGER IF EXISTS ck_carpark_passport_sync_cloud_trigger ON ck_carpark_passport_sync;

-- version 58 cs 
CREATE TRIGGER ck_carpark_passport_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_passport_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 59 cs
DROP TRIGGER IF EXISTS ck_carpark_car_owner_sync_cloud_trigger ON ck_carpark_car_owner_sync;

-- version 60 cs 
CREATE TRIGGER ck_carpark_car_owner_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_car_owner_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 61 cs
DROP TRIGGER IF EXISTS ck_carpark_duty_number_cloud_trigger ON ck_carpark_duty_number;

-- version 62 cs 
CREATE TRIGGER ck_carpark_duty_number_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_duty_number FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 63 cs
DROP TRIGGER IF EXISTS ck_carpark_discount_project_sync_cloud_trigger ON ck_carpark_discount_project_sync;

-- version 64 cs
CREATE TRIGGER ck_carpark_discount_project_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_discount_project_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 65 cs
DROP TRIGGER IF EXISTS ck_carpark_merchant_cloud_trigger ON ck_carpark_merchant;

-- version 66 cs
CREATE TRIGGER ck_carpark_merchant_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_merchant FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 67 cs
DROP TRIGGER IF EXISTS ck_carpark_merchant_user_cloud_trigger ON ck_carpark_merchant_user;

-- version 68 cs
CREATE TRIGGER ck_carpark_merchant_user_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_merchant_user FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 69 cs
DROP TRIGGER IF EXISTS ck_carpark_merchant_coupon_proj_cloud_trigger ON ck_carpark_merchant_coupon_proj;

-- version 70 cs
CREATE TRIGGER ck_carpark_merchant_coupon_proj_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_merchant_coupon_proj FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 71 cs
DROP TRIGGER IF EXISTS ck_carpark_merchant_coupon_rule_cloud_trigger ON ck_carpark_merchant_coupon_rule;

-- version 72 cs
CREATE TRIGGER ck_carpark_merchant_coupon_rule_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_merchant_coupon_rule FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 73 cs
DROP TRIGGER IF EXISTS ck_carpark_merchant_coupon_order_cloud_trigger ON ck_carpark_merchant_coupon_order;

-- version 74 cs
CREATE TRIGGER ck_carpark_merchant_coupon_order_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_merchant_coupon_order FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 75 cs
DROP TRIGGER IF EXISTS ck_carpark_presence_record_cloud_trigger ON ck_carpark_presence_record;

-- version 76 cs
CREATE TRIGGER ck_carpark_presence_record_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_presence_record FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 77 cs
DROP TRIGGER IF EXISTS ck_carpark_discount_record_cloud_trigger ON ck_carpark_discount_record;

-- version 78 cs
CREATE TRIGGER ck_carpark_discount_record_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_discount_record FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 79 cs
DROP TRIGGER IF EXISTS ck_carpark_pass_record_cloud_trigger ON ck_carpark_pass_record;

-- version 80 cs
CREATE TRIGGER ck_carpark_pass_record_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_pass_record FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 81 cs
DROP TRIGGER IF EXISTS ck_carpark_cancel_pass_record_cloud_trigger ON ck_carpark_cancel_pass_record;

-- version 82 cs
CREATE TRIGGER ck_carpark_cancel_pass_record_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_cancel_pass_record FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 83 cs
DROP TRIGGER IF EXISTS ck_carpark_transaction_cloud_trigger ON ck_carpark_transaction;

-- version 84 cs
CREATE TRIGGER ck_carpark_transaction_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_transaction FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 85 cs
DROP TRIGGER IF EXISTS ck_carpark_merchant_coupon_use_cloud_trigger ON ck_carpark_merchant_coupon_use_record;

-- version 86 cs
CREATE TRIGGER ck_carpark_merchant_coupon_use_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_merchant_coupon_use_record FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 87 cs
DROP TRIGGER IF EXISTS ck_carpark_illegal_pass_cloud_trigger ON ck_carpark_illegal_pass_record;

-- version 88 cs
CREATE TRIGGER ck_carpark_illegal_pass_cloud_trigger AFTER INSERT OR UPDATE ON ck_carpark_illegal_pass_record FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 89 cs
CREATE TABLE IF NOT EXISTS ck_cloud_sync_table(
	id bigint NOT NULL,
	table_name varchar(64) NOT NULL,
	cloud_id varchar(64) NOT NULL,
	state smallint NOT NULL,
	PRIMARY KEY (id)
);

-- version 90 cs
CREATE INDEX ck_cloud_sync_table_index_001 ON ck_cloud_sync_table (cloud_id);

-- version 91 cs
ALTER TABLE ck_cloud_upload_pic ADD COLUMN remote_server_path varchar(300);

-- version 92 cs
DROP TRIGGER IF EXISTS ck_carpark_operation_log_cloud_trigger ON ck_carpark_operation_log;

-- version 93 cs
CREATE TRIGGER ck_carpark_operation_log_cloud_trigger AFTER INSERT ON ck_carpark_operation_log FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

-- version 94 cs
DROP TRIGGER IF EXISTS ck_carpark_visit_auth_sync_cloud_trigger ON ck_carpark_visit_auth_sync;

-- version 95 cs 
CREATE TRIGGER ck_carpark_visit_auth_sync_cloud_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_visit_auth_sync FOR EACH ROW EXECUTE PROCEDURE ck_cloud_ddl_sync_log_trigger();

