
-- version 1 cs
SET client_encoding = 'UTF8';

-- version 2 cs
CREATE TABLE IF NOT EXISTS ck_jdbc_test(
	id smallint NOT NULL,
	PRIMARY KEY (id)
);

-- version 3 cs
CREATE TABLE IF NOT EXISTS ck_ddl_sync_log(
    id bigint NOT NULL,
	table_name varchar(64) NOT NULL,
	pk_value bigint NOT NULL,
	op_type char(1) NOT NULL,
	op_time timestamp NOT NULL,
	PRIMARY KEY (id)
);

-- version 4 cs
CREATE SEQUENCE ck_ddl_sync_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 5 cs
CREATE INDEX ck_ddl_sync_log_index_001 ON ck_ddl_sync_log (table_name,op_time);

-- version 6 cs $$;
CREATE OR REPLACE FUNCTION ck_ddl_sync_log_trigger() RETURNS trigger LANGUAGE plpgsql AS $$
     DECLARE
     d_newlogid ck_ddl_sync_log.id%TYPE;
     d_table_name ck_ddl_sync_log.table_name%TYPE;
     d_id_value ck_ddl_sync_log.pk_value%TYPE;
     d_optype ck_ddl_sync_log.op_type%TYPE;
     d_op_time ck_ddl_sync_log.op_time%TYPE;
     BEGIN 
	    d_table_name := TG_RELNAME;
	    d_optype := NULL;
        IF TG_OP = 'DELETE' THEN
            d_optype :='D';
            d_id_value :=OLD.id;
        ELSIF TG_OP = 'UPDATE' THEN
            d_optype :='U';
            d_id_value :=NEW.id;
        ELSIF TG_OP = 'INSERT' THEN
            d_optype :='I';
            d_id_value :=NEW.id;
        END IF;
        IF (d_optype IS NOT NULL) THEN
          d_newlogid :=nextval('ck_ddl_sync_log_seq');
          d_op_time :=now();
          INSERT INTO ck_ddl_sync_log (id,table_name,pk_value,op_type,op_time) VALUES (d_newlogid,d_table_name,d_id_value,d_optype,d_op_time);
        END IF;
    RETURN NULL;
    END;
$$;

-- version 7 cs
CREATE TABLE IF NOT EXISTS ck_ddl_sync_table_log(
	table_name varchar(64) NOT NULL,
	latest_sync_log_id bigint NOT NULL DEFAULT 0,
	latest_sync_log_time timestamp NOT NULL,
	PRIMARY KEY (table_name)
);

-- version 8 cs
CREATE SEQUENCE ck_common_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 9 cs
CREATE TABLE IF NOT EXISTS ck_carpark_local_config(
     id integer NOT NULL,
     host_no varchar(64) NOT NULL,
     host_use smallint  NOT NULL,
     net_mode smallint  NOT NULL,
     seq_prefix integer NOT NULL,
     server_host_port varchar(100),
	 auth_info varchar(3000),
	 carpark_id integer NOT NULL,
	 project_id integer NOT NULL,
	 PRIMARY KEY (id)
);

-- version 10 cs
CREATE TABLE IF NOT EXISTS ck_carpark_sync(
   id integer NOT NULL,
   carpark_name varchar(64) NOT NULL,
   lan_sign_key varchar(64),
   cloud_carpark_id varchar(64),
   cloud_carpark_sign_key varchar(64),
   valid_date varchar(100),
   created_time timestamp  NOT NULL,
   last_updated_time timestamp NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 11 cs
DROP TRIGGER IF EXISTS ck_carpark_sync_log_trigger ON ck_carpark_sync;

-- version 12 cs
CREATE TRIGGER ck_carpark_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 13 cs
CREATE TABLE IF NOT EXISTS ck_carpark_host_sync(
	id bigint NOT NULL,
	host_no varchar(45) NOT NULL,
	host_name varchar(45) NOT NULL,
	host_type smallint NOT NULL,
	host_use smallint NOT NULL,
	net_mode smallint NOT NULL,
	host_ip varchar(45) NULL,
	host_port integer NULL,
	disable smallint NOT NULL DEFAULT 0,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL ,
	project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 14 cs
CREATE INDEX ck_carpark_host_sync_index_001 ON ck_carpark_host_sync (host_no);

-- version 15 cs
DROP TRIGGER IF EXISTS ck_carpark_host_sync_log_trigger ON ck_carpark_host_sync;

-- version 16 cs
CREATE TRIGGER ck_carpark_host_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_host_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 17 cs
CREATE TABLE IF NOT EXISTS ck_carpark_user_sync(
   id bigint NOT NULL,
   user_phone varchar(45),
   user_code varchar(45) NOT NULL,
   user_name varchar(45) NOT NULL,
   password varchar(32) NOT NULL,
   role_no varchar(45) NOT NULL,
   user_state smallint NOT NULL DEFAULT 0,
   can_del smallint NOT NULL DEFAULT 1,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL ,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 18 cs
CREATE INDEX ck_carpark_user_sync_index_001 ON ck_carpark_user_sync (user_code);

-- version 19 cs
DROP TRIGGER IF EXISTS ck_carpark_user_sync_log_trigger ON ck_carpark_user_sync;

-- version 20 cs
CREATE TRIGGER ck_carpark_user_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_user_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 21 cs
CREATE TABLE IF NOT EXISTS ck_carpark_role_sync (
    id bigint NOT NULL,
    role_no varchar(45) NOT NULL,
    role_name varchar(45) NOT NULL,
    can_del smallint NOT NULL DEFAULT 1,
    created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
    PRIMARY KEY (id)
); 

-- version 22 cs
CREATE INDEX ck_carpark_role_sync_index_001 ON ck_carpark_role_sync (role_no);

-- version 23 cs
DROP TRIGGER IF EXISTS ck_carpark_role_sync_log_trigger ON ck_carpark_role_sync;

-- version 24 cs
CREATE TRIGGER ck_carpark_role_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_role_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 25 cs
CREATE TABLE IF NOT EXISTS ck_carpark_role_permission_sync (
    id bigint NOT NULL,
    role_no varchar(45) NOT NULL,
    permission_no varchar(100) NOT NULL,
    last_updated_time timestamp NOT NULL,
    carpark_id integer NOT NULL ,
    project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 26 cs
CREATE INDEX ck_carpark_role_permission_sync_index_001 ON ck_carpark_role_permission_sync (role_no);

-- version 27 cs
DROP TRIGGER IF EXISTS ck_carpark_role_permission_sync_log_trigger ON ck_carpark_role_permission_sync;

-- version 28 cs
CREATE TRIGGER ck_carpark_role_permission_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_role_permission_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 41 cs
CREATE TABLE IF NOT EXISTS ck_carpark_area_sync(
	  id bigint NOT NULL,
	  area_no varchar(45) NOT NULL,
	  parent_area_no varchar(45) NOT NULL DEFAULT '',
	  area_name varchar(45) NOT NULL,
	  space_quantities integer NOT NULL DEFAULT 0,
	  area_number smallint NOT NULL,
	  area_level smallint NOT NULL,
	  created_time timestamp  NOT NULL,
	  last_updated_time timestamp  NOT NULL,
	  carpark_id integer NOT NULL,
	  project_id integer NOT NULL,
	  PRIMARY KEY (id)
);

-- version 42 cs
CREATE INDEX ck_carpark_area_sync_index_001 ON ck_carpark_area_sync (area_no);

-- version 43 cs
DROP TRIGGER IF EXISTS ck_carpark_area_sync_log_trigger ON ck_carpark_area_sync;

-- version 44 cs
CREATE TRIGGER ck_carpark_area_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_area_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 45 cs
CREATE TABLE IF NOT EXISTS ck_carpark_channel_sync (
    id bigint NOT NULL,
    channel_no varchar(45) NOT NULL,
    channel_name varchar(45) NOT NULL,
    channel_type smallint NOT NULL DEFAULT 0,
    channel_mode smallint NOT NULL DEFAULT 0,
    managed_host_no varchar(45) NOT NULL DEFAULT '',
    channel_number smallint NOT NULL DEFAULT 0,
    disable smallint NOT NULL DEFAULT 0,
    created_time timestamp  NOT NULL,
    last_updated_time timestamp  NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 46 cs
CREATE INDEX ck_carpark_channel_sync_index_001 ON ck_carpark_channel_sync (channel_no);

-- version 47 cs
DROP TRIGGER IF EXISTS ck_carpark_channel_sync_log_trigger ON ck_carpark_channel_sync;

-- version 48 cs
CREATE TRIGGER ck_carpark_channel_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_channel_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 49 cs 
CREATE TABLE IF NOT EXISTS ck_carpark_channel_area_sync(
	id bigint NOT NULL,
	channel_no varchar(45) NOT NULl,
	area_no varchar(45) NOT NULl,
	channel_direction smallint NOT NULL,
    last_updated_time timestamp  NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 50 cs 
CREATE INDEX ck_carpark_channel_area_sync_index_001 ON ck_carpark_channel_area_sync (channel_no, area_no);

-- version 51 cs
DROP TRIGGER IF EXISTS ck_carpark_channel_area_sync_log_trigger ON ck_carpark_channel_area_sync;

-- version 52 cs 
CREATE TRIGGER ck_carpark_channel_area_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_channel_area_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 53 cs
CREATE TABLE IF NOT EXISTS ck_carpark_equipment_sync(
	id bigint NOT NULL,
	equipment_no varchar(45) NOT NULL,
	parent_equipment_no varchar(45) NOT NULL DEFAULT '',
	equipment_name varchar(45) NOT NULL,
	equipment_type smallint NOT NULL,
	equipment_use smallint NOT NULL,
	equipment_driver varchar(45) NULL,
	equipment_manufacturer varchar(45) NULL,
	equipment_model varchar(45) NULL,
	equipment_serial_number varchar(45) NULL,
	equipment_level smallint NOT NULL DEFAULT 1,
	disable smallint NOT NULL DEFAULT 0,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL,
	project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 54 cs
CREATE INDEX ck_carpark_equipment_sync_index_001 ON ck_carpark_equipment_sync (equipment_no);

-- version 55 cs
DROP TRIGGER IF EXISTS ck_carpark_equipment_sync_log_trigger ON ck_carpark_equipment_sync;

-- version 56 cs
CREATE TRIGGER ck_carpark_equipment_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_equipment_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 57 cs
CREATE TABLE IF NOT EXISTS ck_carpark_equipment_config_sync(
    id bigint NOT NULL,
    equipment_no varchar(45) NOT NULL,
	config_key varchar(45) NOT NULL,
	config_value varchar(255) NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL,
	project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 58 cs
CREATE INDEX ck_carpark_equipment_config_sync_index_001 ON ck_carpark_equipment_config_sync (equipment_no,config_key);

-- version 59 cs
DROP TRIGGER IF EXISTS ck_carpark_equipment_config_sync_log_trigger ON ck_carpark_equipment_config_sync;

-- version 60 cs
CREATE TRIGGER ck_carpark_equipment_config_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_equipment_config_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 61 cs
CREATE TABLE IF NOT EXISTS ck_carpark_channel_equipment_sync(
	 id bigint NOT NULL,
     channel_no varchar(45) NOT NULL,
     equipment_no varchar(45) NOT NULL,
     last_updated_time timestamp  NOT NULL,
     carpark_id integer NOT NULL,
     project_id integer NOT NULL,
	 PRIMARY KEY (id)
);

-- version 62 cs
CREATE INDEX ck_carpark_channel_equipment_sync_index_001 ON ck_carpark_channel_equipment_sync (channel_no, equipment_no);

-- version 63 cs
DROP TRIGGER IF EXISTS ck_carpark_channel_equipment_sync_log_trigger ON ck_carpark_channel_equipment_sync;

-- version 64 cs
CREATE TRIGGER ck_carpark_channel_equipment_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_channel_equipment_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 65 cs
CREATE TABLE IF NOT EXISTS ck_carpark_passport_type_sync(
	id bigint NOT NULL,
	passport_type_no varchar(45) NOT NULL,
	passport_type_name varchar(45) NOT NULL,
	pass_type smallint NOT NULL DEFAULT 0,
	use_muti_car smallint NOT NULL DEFAULT 0,
	use_issuer smallint NOT NULL DEFAULT 0,
	passport_type_number smallint NOT NULL DEFAULT 0,
    can_del smallint NOT NULL DEFAULT 1,
	created_time timestamp  NOT NULL,
    last_updated_time timestamp  NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 66 cs
CREATE INDEX ck_carpark_passport_type_sync_index_001 ON ck_carpark_passport_type_sync (passport_type_no);

-- version 67 cs
DROP TRIGGER IF EXISTS ck_carpark_passport_type_sync_log_trigger ON ck_carpark_passport_type_sync;

-- version 68 cs
CREATE TRIGGER ck_carpark_passport_type_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_passport_type_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 69 cs
CREATE TABLE IF NOT EXISTS ck_carpark_car_type_sync(
	id bigint NOT NULL,
	car_type_no varchar(45) NOT NULL,
	car_type_name varchar(45) NOT NULL,
	car_type_number smallint NOT NULL DEFAULT 0,
	can_del smallint NOT NULL DEFAULT 1,
	created_time timestamp  NOT NULL,
    last_updated_time timestamp  NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 70 cs
CREATE INDEX ck_carpark_car_type_sync_index_001 ON ck_carpark_car_type_sync (car_type_no);

-- version 71 cs
DROP TRIGGER IF EXISTS ck_carpark_car_type_sync_log_trigger ON ck_carpark_car_type_sync;

-- version 72 cs
CREATE TRIGGER ck_carpark_car_type_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_car_type_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 73 cs
CREATE TABLE IF NOT EXISTS ck_carpark_attribute_sync(
     id bigint NOT NULL,
     attribute_key varchar(45) NOT NULL,
     attribute_value varchar(100),
     attribute_type smallint NOT NULL,
     can_del smallint NOT NULL,
     created_time timestamp  NOT NULL,
     last_updated_time timestamp  NOT NULL,
     carpark_id integer NOT NULL,
     project_id integer NOT NULL,
	 PRIMARY KEY (id)
);

-- version 74 cs
CREATE INDEX ck_carpark_attribute_sync_index_001 ON ck_carpark_attribute_sync (attribute_key);

-- version 75 cs
DROP TRIGGER IF EXISTS ck_carpark_attribute_sync_log_trigger ON ck_carpark_attribute_sync;

-- version 76 cs 
CREATE TRIGGER ck_carpark_attribute_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_attribute_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 77 cs 
CREATE TABLE IF NOT EXISTS ck_carpark_strategy_sync(
    id bigint NOT NULL,
    strategy_name varchar(45) NOT NULL,
    strategy_value varchar(255) NOT NULL,
    area_no varchar(45) NOT NULL DEFAULT '',
    channel_no varchar(45) NOT NULL DEFAULT '',
    passport_type_no varchar(45) NOT NULL DEFAULT '',
    car_type_no varchar(45) NOT NULL DEFAULT '',
    created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL,
	project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 78 cs
DROP TRIGGER IF EXISTS ck_carpark_strategy_sync_log_trigger ON ck_carpark_strategy_sync;

-- version 79 cs 
CREATE TRIGGER ck_carpark_strategy_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_strategy_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 80 cs
CREATE TABLE IF NOT EXISTS ck_carpark_special_date_sync(
   id bigint NOT NULL,
   special_date date NOT NULL,
   date_type smallint NOT NULL,
   remark varchar(45),
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 81 cs
CREATE INDEX ck_carpark_special_date_sync_index_001 ON ck_carpark_special_date_sync (special_date);

-- version 82 cs
DROP TRIGGER IF EXISTS ck_carpark_special_date_sync_log_trigger ON ck_carpark_special_date_sync;

-- version 83 cs 
CREATE TRIGGER ck_carpark_special_date_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_special_date_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 84 cs
CREATE TABLE IF NOT EXISTS ck_carpark_space_type_sync(
    id bigint NOT NULL,
    space_type_no varchar(45) NOT NULL,
	space_type_name varchar(45) NOT NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL,
	project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 85 cs
CREATE INDEX ck_carpark_space_type_sync_index_001 ON ck_carpark_space_type_sync (space_type_no);

-- version 86 cs
DROP TRIGGER IF EXISTS ck_carpark_space_type_sync_log_trigger ON ck_carpark_space_type_sync;

-- version 87 cs
CREATE TRIGGER ck_carpark_space_type_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_space_type_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 88 cs
CREATE TABLE IF NOT EXISTS ck_carpark_space_type_define_sync(
    id bigint NOT NULL,
    space_type_no varchar(45) NOT NULL,
    passport_type_no varchar(45) NOT NULL,
	car_type_no varchar(45) NOT NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL,
	project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 89 cs
CREATE INDEX ck_carpark_space_type_define_sync_index_001 ON ck_carpark_space_type_define_sync (space_type_no);

-- version 90 cs
DROP TRIGGER IF EXISTS ck_carpark_space_type_define_sync_log_trigger ON ck_carpark_space_type_define_sync;

-- version 91 cs
CREATE TRIGGER ck_carpark_space_type_define_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_space_type_define_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();
	
-- version 92 cs
CREATE TABLE IF NOT EXISTS ck_carpark_space_type_quantity_sync(
    id bigint NOT NULL,
    space_type_no varchar(45) NOT NULL,
	area_no varchar(45) NOT NULL,
	quantity integer NOT NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL,
	project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 93 cs
CREATE INDEX ck_carpark_space_type_quantity_sync_index_001 ON ck_carpark_space_type_quantity_sync (space_type_no);

-- version 94 cs
DROP TRIGGER IF EXISTS ck_carpark_space_type_quantity_sync_log_trigger ON ck_carpark_space_type_quantity_sync;

-- version 95 cs
CREATE TRIGGER ck_carpark_space_type_quantity_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_space_type_quantity_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 96 cs
CREATE TABLE IF NOT EXISTS ck_carpark_pass_permission_sync(
   id bigint NOT NULL,
   pass_permission_no varchar(45) NOT NULL,
   auth_type smallint NOT NULL,
   auth_type_no varchar(45) NOT NULL,
   auth_value smallint NOT NULL,
   date_range_type smallint NOT NULL,
   date_range_value varchar(45) NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 97 cs
CREATE INDEX ck_carpark_pass_permission_sync_index_001 ON ck_carpark_pass_permission_sync (auth_type_no);

-- version 98 cs
CREATE INDEX ck_carpark_pass_permission_sync_index_002 ON ck_carpark_pass_permission_sync (pass_permission_no);

-- version 99 cs
DROP TRIGGER IF EXISTS ck_carpark_pass_permission_sync_log_trigger ON ck_carpark_pass_permission_sync;

-- version 100 cs
CREATE TRIGGER ck_carpark_pass_permission_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_pass_permission_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();
	
-- version 101 cs
CREATE TABLE IF NOT EXISTS ck_carpark_date_range_sync(
	id bigint NOT NULL,
	date_range_no varchar(45) NOT NULL,
	ref_type smallint NOT NULL,
	ref_no varchar(45) NOT NULL,
	range_begin timestamp NOT NULL, 
	range_end timestamp NOT NULL, 
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	carpark_id integer NOT NULL,
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 102 cs
CREATE INDEX ck_carpark_date_range_sync_index_001 ON ck_carpark_date_range_sync (date_range_no);

-- version 103 cs
CREATE INDEX ck_carpark_date_range_sync_index_002 ON ck_carpark_date_range_sync (ref_no,ref_type);

-- version 104 cs
DROP TRIGGER IF EXISTS ck_carpark_date_range_sync_log_trigger ON ck_carpark_date_range_sync;

-- version 105 cs
CREATE TRIGGER ck_carpark_date_range_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_date_range_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 106 cs
CREATE TABLE IF NOT EXISTS ck_carpark_pass_permission_channel_sync(
   id bigint NOT NULL,
   pass_permission_no varchar(45) NOT NULL,
   channel_no varchar(45) NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 107 cs
CREATE INDEX ck_carpark_pass_permission_channel_sync_index_001 ON ck_carpark_pass_permission_channel_sync (pass_permission_no,channel_no);

-- version 108 cs
DROP TRIGGER IF EXISTS ck_carpark_pass_permission_channel_sync_log_trigger ON ck_carpark_pass_permission_channel_sync;

-- version 109 cs
CREATE TRIGGER ck_carpark_pass_permission_channel_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_pass_permission_channel_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 110 cs
CREATE TABLE IF NOT EXISTS ck_carpark_recharge_rule_sync(
   id bigint NOT NULL,
   recharge_rule_no varchar(45) NOT NULL,
   passport_type_no varchar(45) NOT NULL,
   car_type_no varchar(45) NOT NULL,
   recharge_quantity integer NOT NULL,
   recharge_unit smallint NOT NULL,
   charge_amount decimal(10,2) NOT NULL DEFAULT 0.00,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 111 cs
CREATE INDEX ck_carpark_recharge_rule_sync_index_001 ON ck_carpark_recharge_rule_sync (recharge_rule_no);

-- version 112 cs
CREATE INDEX ck_carpark_recharge_rule_sync_index_002 ON ck_carpark_recharge_rule_sync (passport_type_no,car_type_no);

-- version 113 cs
DROP TRIGGER IF EXISTS ck_carpark_recharge_rule_sync_log_trigger ON ck_carpark_recharge_rule_sync;

-- version 114 cs
CREATE TRIGGER ck_carpark_recharge_rule_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_recharge_rule_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 115 cs
CREATE TABLE IF NOT EXISTS ck_carpark_charge_rule_sync(
  id bigint NOT NULL,
  charge_rule_no varchar(45) NOT NULL,
  passport_type_no varchar(45) NOT NULL,
  car_type_no varchar(45) NOT NULL,
  area_no varchar(45) NOT NULL,
  work_mode smallint NOT NULL DEFAULT 0,
  max_one_time smallint DEFAULT 0,
  max_one_time_money decimal(8,2),
  max_period smallint NOT NULL DEFAULT 0,
  max_period_len smallint NOT NULL DEFAULT 0,
  max_period_money decimal(8,2),
  max_work_day smallint NOT NULL DEFAULT 0,
  max_work_day_money decimal(8,2),
  max_holiday smallint NOT NULL DEFAULT 0,
  max_holiday_day_money decimal(8,2),
  muti_segment_charge smallint NOT NULL DEFAULT 0,
  muti_segment_charge_h smallint NOT NULL DEFAULT 0,
  period_multi smallint NOT NULL DEFAULT 0,
  period_multi_hours smallint NOT NULL DEFAULT 24,
  period_multi_max_money decimal(8,2),
  period_multi_max_money_h decimal(8,2),
  period_multi_begin_time smallint DEFAULT 0,
  period_multi_free_time smallint DEFAULT 0,
  period_multi_first_segment smallint DEFAULT 0,
  created_time timestamp NOT NULL,
  last_updated_time timestamp  NOT NULL,
  carpark_id integer NOT NULL,
  project_id integer NOT NULL,
  max_free_time smallint NOT NULL DEFAULT 0,
  max_free_time_period_len smallint NOT NULL DEFAULT 24,
  max_free_time_times smallint NOT NULL DEFAULT 0,
  PRIMARY KEY(id)
);

-- version 116 cs
CREATE INDEX ck_carpark_charge_rule_sync_index_001 ON ck_carpark_charge_rule_sync (charge_rule_no);

-- version 117 cs
CREATE INDEX ck_carpark_charge_rule_sync_index_002 ON ck_carpark_charge_rule_sync (passport_type_no,car_type_no,area_no);

-- version 118 cs
DROP TRIGGER IF EXISTS ck_carpark_charge_rule_sync_log_trigger ON ck_carpark_charge_rule_sync;

-- version 119 cs
CREATE TRIGGER ck_carpark_charge_rule_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_charge_rule_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 120 cs
CREATE TABLE IF NOT EXISTS ck_carpark_charge_segment_rule_sync(
  id bigint NOT NULL,  
  charge_segment_rule_no varchar(45) NOT NULL,
  charge_rule_no varchar(45) NOT NULL,
  start_time smallint,
  end_time smallint,
  free_time_len smallint,
  first_time_len smallint,
  first_time_money decimal(8,2),
  unit_time_len smallint,
  unit_time_money decimal(8,2),
  max_change smallint,
  max_hours smallint,
  max_money decimal(8,2),
  times_money decimal(8,2),
  period_length smallint,
  next_period_strategy smallint,
  range_take_high smallint,
  charge_type smallint NOT NULL DEFAULT 0,
  work_mode_type smallint NOT NULL DEFAULT 0,
  created_time timestamp NOT NULL,
  last_updated_time timestamp  NOT NULL,
  carpark_id integer NOT NULL,
  project_id integer NOT NULL,
  PRIMARY KEY (id)
);

-- version 121 cs
CREATE INDEX ck_carpark_charge_segment_rule_sync_index_001 ON ck_carpark_charge_segment_rule_sync (charge_rule_no);

-- version 122 cs
CREATE INDEX ck_carpark_charge_segment_rule_sync_index_002 ON ck_carpark_charge_segment_rule_sync (charge_segment_rule_no);

-- version 123 cs
DROP TRIGGER IF EXISTS ck_carpark_charge_segment_rule_sync_log_trigger ON ck_carpark_charge_segment_rule_sync;

-- version 124 cs
CREATE TRIGGER ck_carpark_charge_segment_rule_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_charge_segment_rule_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 125 cs
CREATE TABLE IF NOT EXISTS ck_carpark_charge_time_len_range_sync(
  id bigint NOT NULL,  
  charge_time_len_range_no varchar(45) NOT NULL,
  charge_segment_rule_no varchar(45) NOT NULL,
  time_len smallint,
  money decimal(8,2) NOT NULL,
  created_time timestamp NOT NULL,
  last_updated_time timestamp  NOT NULL,
  carpark_id integer NOT NULL,
  project_id integer NOT NULL,
  PRIMARY KEY (id)
);

-- version 126 cs
CREATE INDEX ck_carpark_charge_time_len_range_sync_index_001 ON ck_carpark_charge_time_len_range_sync (charge_time_len_range_no);

-- version 127 cs
CREATE INDEX ck_carpark_charge_time_len_range_sync_index_002 ON ck_carpark_charge_time_len_range_sync (charge_segment_rule_no);

-- version 128 cs
DROP TRIGGER IF EXISTS ck_carpark_charge_time_len_range_sync_log_trigger ON ck_carpark_charge_time_len_range_sync;

-- version 129 cs
CREATE TRIGGER ck_carpark_charge_time_len_range_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_charge_time_len_range_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 130 cs
CREATE TABLE IF NOT EXISTS ck_carpark_passport_sync (
	  id bigint NOT NULL,
	  passport_no varchar(45) NOT NULL,
	  car_owner_no varchar(64) DEFAULT '',
	  passport_type_no varchar(45) NOT NULL,
	  car_type_no varchar(45) NOT NULL,
	  passport_number varchar(64) DEFAULT '',
	  medium_type smallint NOT NULL,
	  surface_number varchar(64),
	  register_plate varchar(20) DEFAULT '',
	  parking_space_no varchar(64),
	  ic_sector varchar(45),
	  ic_key varchar(45),
	  ic_as_id smallint NOT NULL DEFAULT 0,
	  passport_state smallint NOT NULL DEFAULT 0,
	  deadline timestamp,
	  number_times integer NOT NULL DEFAULT 0,
	  balance decimal(10,2) NOT NULL DEFAULT 0,
	  remain_hours integer NOT NULL DEFAULT 0,
	  cash_pledge decimal(7,2) NOT NULL DEFAULT 0,
	  remark varchar(200),
	  start_date timestamp,
	  stop_date timestamp,
	  valid_date timestamp,
	  forbid_online_pay smallint,
	  car_color varchar(45),
	  car_logo varchar(45),
	  reg_source smallint,
	  reg_time timestamp  NOT NULL,
	  vehicle_number varchar(64),
	  created_time timestamp  NOT NULL,
	  last_updated_time timestamp  NOT NULL,
	  carpark_id integer NOT NULL,
	  project_id integer NOT NULL,
	  PRIMARY KEY (id)
);

-- version 131 cs
CREATE INDEX ck_carpark_passport_sync_index_001 ON ck_carpark_passport_sync (passport_number);

-- version 132 cs
CREATE INDEX ck_carpark_passport_sync_index_002 ON ck_carpark_passport_sync (passport_no);

-- version 133 cs
DROP TRIGGER IF EXISTS ck_carpark_passport_sync_log_trigger ON ck_carpark_passport_sync;

-- version 134 cs 
CREATE TRIGGER ck_carpark_passport_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_passport_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 135 cs 
CREATE TABLE IF NOT EXISTS ck_carpark_car_owner_sync (
  id bigint NOT NULL,
  car_owner_no varchar(64) NOT NULL,
  car_owner_name varchar(45),
  id_number varchar(64),
  driver_number varchar(64),
  address varchar(200),
  phone_number varchar(20),
  email varchar(100),
  sex smallint,
  head_photo varchar(200),
  birthday date,
  attribute1 varchar(100),
  attribute2 varchar(100),
  attribute3 varchar(100),
  attribute4 varchar(100),
  attribute5 varchar(100),
  attribute6 varchar(100),
  attribute7 varchar(100),
  attribute8 varchar(100),
  attribute9 varchar(100),
  attribute10 varchar(100),
  remark varchar(200),
  created_time timestamp  NOT NULL,
  last_updated_time timestamp  NOT NULL,
  carpark_id integer NOT NULL,
  project_id integer NOT NULL,
  PRIMARY KEY (id)
);

-- version 136 cs
CREATE INDEX ck_carpark_car_owner_sync_index_001 ON ck_carpark_car_owner_sync (car_owner_no);

-- version 137 cs
DROP TRIGGER IF EXISTS ck_carpark_car_owner_sync_log_trigger ON ck_carpark_car_owner_sync;

-- version 138 cs 
CREATE TRIGGER ck_carpark_car_owner_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_car_owner_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 139 cs
CREATE TABLE IF NOT EXISTS ck_carpark_presence_record(
      id bigint NOT NULL,
	  enter_record_no varchar(45),
	  exit_record_no varchar(45),
	  passport_no varchar(45),
	  passport_number varchar(64),
	  medium_type smallint,
	  pass_type smallint,
	  passport_type_no varchar(45),
	  passport_type_name varchar(45),
	  car_owner_no varchar(64),
	  car_owner_name varchar(45),
	  car_owner_addr varchar(100),
      area_no varchar(45),
	  parent_area_no varchar(45),
	  area_level smallint,
	  area_name varchar(45),
	  pass_time timestamp,
	  pass_plate varchar(20),
	  pass_channel_no varchar(45),
	  pass_host_no varchar(45),
	  pass_duty_user_code varchar(45),
	  pass_car_type_no varchar(45),
	  plate_color varchar(15), 
	  car_logo varchar(45),
	  car_color varchar(15),
      enter_time timestamp,
	  enter_channel_no varchar(45),
	  enter_channel_name varchar(45),
	  enter_car_type_no varchar(45),
	  enter_car_type_name varchar(45),
	  enter_default_car_type_no varchar(45),
	  enter_passport_type_no varchar(45),
	  enter_plate varchar(20),
	  enter_plate_source smallint,
	  enter_obu_plate varchar(20),
	  enter_reg_plate varchar(20),
	  enter_plate_modify_time timestamp,
	  enter_plate_modify_user_name varchar(45),
	  enter_duty_no varchar(45),
	  enter_host_no varchar(45),
	  enter_host_name varchar(45),
	  enter_duty_user_code varchar(45),
	  enter_duty_user_name varchar(45),
	  enter_lan_state smallint,
	  enter_car_pic varchar(200),
	  enter_plate_pic varchar(200),
	  enter_face_pic varchar(200),
	  enter_remark varchar(100),
	  enter_valid_date timestamp,
	  enter_balance decimal(10,2),
	  exit_time timestamp,
	  exit_channel_no varchar(45),
	  exit_channel_name varchar(45),
	  exit_car_type_no varchar(45),
	  exit_car_type_name varchar(45),
	  exit_default_car_type_no varchar(45),
	  exit_plate varchar(20),
	  exit_plate_source smallint,
	  exit_obu_plate varchar(20),
	  exit_reg_plate varchar(20),
	  exit_host_no varchar(45),
	  exit_host_name varchar(45),
	  exit_duty_no varchar(45),
	  exit_duty_user_code varchar(45),
	  exit_duty_user_name varchar(45),
	  exit_lan_state smallint,
	  exit_car_pic varchar(200),
	  exit_plate_pic varchar(200),
	  exit_face_pic varchar(200),
	  exit_remark varchar(100),
	  exit_valid_date timestamp,
	  exit_balance decimal(10,2),
	  exit_fee_time_length integer,
	  certificate_pic varchar(200),
	  exit_should_charge decimal(10,2),
	  period_multi_start timestamp,
	  period_multi_received decimal(10,2),
	  period_multi_free decimal(10,2),
	  next_period_multi_start timestamp,
	  next_period_multi_cur decimal(10,2),
	  exit_fee_start_time timestamp,
	  discount_money decimal(10,2),
	  already_paid decimal(10,2),
	  already_paid_method smallint,
	  already_paid_scene smallint,
	  cash_pay decimal(10,2),
	  deduct_money decimal(10,2),
	  record_state smallint,
	  carpark_id integer NOT NULL,
	  project_id integer NOT NULL,
	  discount_times smallint, 
	  discount_project_no varchar(45),
      discount_project_name varchar(45),
      discount_merchant_type smallint,
      discount_merchant_no varchar(45),
      discount_merchant_name varchar(45),
      take_plate_number varchar(20),
      take_enter_time timestamp,
      take_passport_type_no varchar(45),
      secret_free_payment smallint,
      pass_state_value smallint,
      discount_method smallint,
      discount_value integer,
      discount_source smallint,
      already_paid_times smallint, 
      already_paid_charge_org smallint,
      already_paid_time timestamp,
      discount_time timestamp,
	  PRIMARY KEY (id)
);

-- version 140 cs
CREATE INDEX ck_carpark_presence_record_index_001 ON ck_carpark_presence_record (passport_number);

-- version 143 cs
CREATE TABLE IF NOT EXISTS ck_carpark_operation_log(
	id bigint NOT NULL,
	op_cat smallint NOT NULL,
	op_type smallint NOT NULL,
	op_des varchar(500),
	op_time timestamp NOT NULL,
	op_user_code varchar(45) NOT NULL,
	op_user_name varchar(45) NOT NULL,
	carpark_id integer NOT NULL,
	project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 144 cs
CREATE INDEX ck_carpark_operation_log_index_001 ON ck_carpark_operation_log (op_time);

-- version 145 cs
CREATE TABLE IF NOT EXISTS ck_carpark_transaction (
	  id bigint NOT NULL,
	  tansaction_no varchar(64),
	  tran_type smallint NOT NULL,
	  service_type smallint NOT NULL,
	  plate_number varchar(20),
	  passport_no varchar(45),
	  passport_number varchar(64),
	  medium_type smallint,
	  pass_type smallint, 
	  passport_type_no varchar(45),
	  passport_type_name varchar(45),
	  car_type_no varchar(45),
	  car_type_name varchar(45),
	  order_no varchar(64),
	  tran_money decimal(12,2) NOT NULL,
	  tran_time timestamp NOT NULL,
	  pay_method smallint NOT NULL,
	  pay_scene smallint NOT NULL,
	  charge_org smallint NOT NULL,
	  pay_entry smallint NOT NULL,
	  tran_area_no varchar(45),
	  tran_area_name varchar(45),
	  tran_channel_no varchar(45),
	  tran_channel_name varchar(45),
	  tran_user_no varchar(64),
	  tran_user_name varchar(45),
      enter_record_no varchar(45),
      enter_time timestamp,
      operate_user_code varchar(45),
      operate_user_name varchar(45),
      balance_before decimal(12,2),
      recharge_money decimal(12,2),
      balance decimal(12,2),
      valid_date_before timestamp,
      start_date timestamp,
      end_date timestamp,
      tran_quantity integer,
      tran_unit smallint,
      tran_des varchar(200),
      should_charge decimal(12,2),
      discount_money decimal(12,2),
      goods_no varchar(45),
      goods_name varchar(45),
      host_no varchar(45),
	  host_name varchar(45),
      duty_no varchar(45),
      created_time timestamp DEFAULT NULL,
      carpark_id integer NOT NULL,
	  project_id integer NOT NULL,
	  already_paid decimal(10,2),
	  period_multi_free decimal(10,2),	  
      PRIMARY KEY (id) 
);

-- version 146 cs
CREATE INDEX ck_carpark_transaction_index_001 ON ck_carpark_transaction (tran_time);

-- version 147 cs
CREATE SEQUENCE ck_carpark_transaction_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 148 cs
CREATE SEQUENCE ck_carpark_operation_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 149 cs
CREATE TABLE IF NOT EXISTS ck_carpark_duty_number(
  id bigint NOT NULL,
  duty_no varchar(45) NOT NULL,
  start_time timestamp,
  end_time timestamp,
  login_duty_user_code varchar(45),
  login_host_no varchar(45),
  last_login_time timestamp,
  state smallint,
  carpark_id integer NOT NULL,
  project_id integer NOT NULL,
  PRIMARY KEY (id) 
);

-- version 150 cs
CREATE INDEX ck_carpark_duty_number_index_001 ON ck_carpark_duty_number (start_time);

-- version 151 cs
CREATE INDEX ck_carpark_duty_number_index_002 ON ck_carpark_duty_number (duty_no);

-- version 152 cs
CREATE SEQUENCE ck_carpark_duty_number_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 153 cs
CREATE TABLE IF NOT EXISTS ck_carpark_plate_car_type(
  id bigint NOT NULL,
  plate_number varchar(20) NOT NULL,
  car_type_no varchar(45) NOT NULL, 
  last_updated_time timestamp NOT NULL,
  carpark_id integer NOT NULL,
  project_id integer NOT NULL,
  PRIMARY KEY (id)
);

-- version 154 cs
CREATE INDEX ck_carpark_plate_car_type_index_001 ON ck_carpark_plate_car_type (plate_number);

-- version 155 cs
CREATE SEQUENCE ck_carpark_plate_car_type_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 156 cs
CREATE TABLE IF NOT EXISTS ck_carpark_regplate_record(
   id bigint NOT NULL,
   reg_no varchar(45) NOT NULL,
   reg_time timestamp NOT NULL,
   plate_number varchar(20) NOT NULL,
   camera_no varchar(45),
   channel_no varchar(45),   
   plate_color varchar(10),
   plate_type varchar(20),
   plate_judge varchar(10),
   plate_confi varchar(10),
   car_color varchar(10),
   car_logo varchar(20),
   car_dir varchar(20),
   car_type varchar(20),
   car_speed varchar(10),   
   host_no varchar(45),
   big_pic_path varchar(200),
   small_pic_path varchar(200),
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,   
   trigger_method smallint,
   PRIMARY KEY (id) 
);

-- version 157 cs
CREATE SEQUENCE ck_carpark_regplate_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 158 cs
CREATE INDEX ck_carpark_regplate_record_index_001 ON ck_carpark_regplate_record (reg_time);

-- version 159 cs
CREATE TABLE IF NOT EXISTS ck_carpark_dispatch_task(
    id bigint NOT NULL,
    host_no varchar(45) NOT NULL,
    service_name varchar(100) NOT NULL,
    json_data varchar(3000),
    created_time timestamp NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,  
    PRIMARY KEY (id)
);

-- version 160 cs
CREATE INDEX ck_carpark_dispatch_task_index_001 ON ck_carpark_dispatch_task (host_no);

-- version 161 cs
CREATE SEQUENCE ck_carpark_dispatch_task_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 162 cs
CREATE TABLE IF NOT EXISTS ck_carpark_pass_record(
      id bigint NOT NULL,
	  enter_record_no varchar(45),
	  exit_record_no varchar(45),
	  passport_no varchar(45),
	  passport_number varchar(64),
	  medium_type smallint,
	  pass_type smallint,
	  passport_type_no varchar(45),
	  passport_type_name varchar(45),
	  car_owner_no varchar(64),
	  car_owner_name varchar(45),
	  car_owner_addr varchar(100),
      area_no varchar(45),
	  parent_area_no varchar(45),
	  area_level smallint,
	  area_name varchar(45),
	  pass_time timestamp,
	  pass_plate varchar(20),
	  pass_channel_no varchar(45),
	  pass_host_no varchar(45),
	  pass_duty_user_code varchar(45),
	  pass_car_type_no varchar(45),
	  plate_color varchar(15), 
	  car_logo varchar(45),
	  car_color varchar(15),
      enter_time timestamp,
	  enter_channel_no varchar(45),
	  enter_channel_name varchar(45),
	  enter_car_type_no varchar(45),
	  enter_car_type_name varchar(45),	
	  enter_default_car_type_no varchar(45),
	  enter_passport_type_no varchar(45),
	  enter_plate varchar(20),
	  enter_plate_source smallint,
	  enter_obu_plate varchar(20),
	  enter_reg_plate varchar(20),
	  enter_plate_modify_time timestamp,
	  enter_plate_modify_user_name varchar(45),
	  enter_duty_no varchar(45),
	  enter_host_no varchar(45),
	  enter_host_name varchar(45),
	  enter_duty_user_code varchar(45),
	  enter_duty_user_name varchar(45),
	  enter_lan_state smallint,
	  enter_car_pic varchar(200),
	  enter_plate_pic varchar(200),
	  enter_face_pic varchar(200),
	  enter_remark varchar(100),
	  enter_valid_date timestamp,
	  enter_balance decimal(10,2),
	  exit_time timestamp,
	  exit_channel_no varchar(45),
	  exit_channel_name varchar(45),
	  exit_car_type_no varchar(45),
	  exit_default_car_type_no varchar(45),
	  exit_car_type_name varchar(45),
	  exit_plate varchar(20),
	  exit_plate_source smallint,
	  exit_obu_plate varchar(20),
	  exit_reg_plate varchar(20),
	  exit_host_no varchar(45),
	  exit_host_name varchar(45),
	  exit_duty_no varchar(45),
	  exit_duty_user_code varchar(45),
	  exit_duty_user_name varchar(45),
	  exit_lan_state smallint,
	  exit_car_pic varchar(200),
	  exit_plate_pic varchar(200),
	  exit_face_pic varchar(200),
	  exit_remark varchar(100),
	  exit_valid_date timestamp,
	  exit_balance decimal(10,2),
	  exit_fee_time_length integer,
	  certificate_pic varchar(200),
	  exit_should_charge decimal(10,2),
	  period_multi_start timestamp,
	  period_multi_received decimal(10,2),
	  period_multi_free decimal(10,2),
	  next_period_multi_start timestamp,
	  next_period_multi_cur decimal(10,2),
	  exit_fee_start_time timestamp,
	  discount_money decimal(10,2),
	  already_paid decimal(10,2),
	  already_paid_method smallint,
	  already_paid_scene smallint,
	  cash_pay decimal(10,2),
	  deduct_money decimal(10,2),
	  record_state smallint,
	  carpark_id integer NOT NULL,
	  project_id integer NOT NULL,
	  discount_times smallint, 
	  discount_project_no varchar(45),
      discount_project_name varchar(45),
      discount_merchant_type smallint,
      discount_merchant_no varchar(45),
      discount_merchant_name varchar(45),
      take_plate_number varchar(20),
      take_enter_time timestamp,
      take_passport_type_no varchar(45),
      secret_free_payment smallint,
      pass_state_value smallint,
      discount_method smallint,
      discount_value integer,
      discount_source smallint,
      already_paid_times smallint, 
      already_paid_charge_org smallint,
      already_paid_time timestamp,
      discount_time timestamp,
	  PRIMARY KEY (id)
);

-- version 163 cs
CREATE SEQUENCE ck_carpark_pass_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 164 cs
CREATE INDEX ck_carpark_pass_record_index_001 ON ck_carpark_pass_record (pass_time);

-- version 165 cs
CREATE INDEX ck_carpark_pass_record_index_002 ON ck_carpark_pass_record (passport_number);

-- version 166 cs
CREATE TABLE IF NOT EXISTS ck_carpark_cancel_pass_record(
      id bigint NOT NULL,
	  enter_record_no varchar(45),
	  exit_record_no varchar(45),
	  passport_no varchar(45),
	  passport_number varchar(64),
	  medium_type smallint,
	  pass_type smallint,
	  passport_type_no varchar(45),
	  passport_type_name varchar(45),
	  car_owner_no varchar(64),
	  car_owner_name varchar(45),
	  car_owner_addr varchar(100),
      area_no varchar(45),
	  parent_area_no varchar(45),
	  area_level smallint,
	  area_name varchar(45),
	  pass_time timestamp,
	  pass_plate varchar(20),
	  pass_channel_no varchar(45),
	  pass_host_no varchar(45),
	  pass_duty_user_code varchar(45),
	  pass_car_type_no varchar(45),
	  plate_color varchar(15), 
	  car_logo varchar(45),
	  car_color varchar(15),
      enter_time timestamp,
	  enter_channel_no varchar(45),
	  enter_channel_name varchar(45),
	  enter_car_type_no varchar(45),
	  enter_car_type_name varchar(45),	
	  enter_default_car_type_no varchar(45),
	  enter_passport_type_no varchar(45),
	  enter_plate varchar(20),
	  enter_plate_source smallint,
	  enter_obu_plate varchar(20),
	  enter_reg_plate varchar(20),
	  enter_plate_modify_time timestamp,
	  enter_plate_modify_user_name varchar(45),
	  enter_duty_no varchar(45),
	  enter_host_no varchar(45),
	  enter_host_name varchar(45),
	  enter_duty_user_code varchar(45),
	  enter_duty_user_name varchar(45),
	  enter_lan_state smallint,
	  enter_car_pic varchar(200),
	  enter_plate_pic varchar(200),
	  enter_face_pic varchar(200),
	  enter_remark varchar(100),
	  enter_valid_date timestamp,
	  enter_balance decimal(10,2),
	  exit_time timestamp,
	  exit_channel_no varchar(45),
	  exit_channel_name varchar(45),
	  exit_car_type_no varchar(45),
	  exit_default_car_type_no varchar(45),
	  exit_car_type_name varchar(45),
	  exit_plate varchar(20),
	  exit_plate_source smallint,
	  exit_obu_plate varchar(20),
	  exit_reg_plate varchar(20),
	  exit_host_no varchar(45),
	  exit_host_name varchar(45),
	  exit_duty_no varchar(45),
	  exit_duty_user_code varchar(45),
	  exit_duty_user_name varchar(45),
	  exit_lan_state smallint,
	  exit_car_pic varchar(200),
	  exit_plate_pic varchar(200),
	  exit_face_pic varchar(200),
	  exit_remark varchar(100),
	  exit_valid_date timestamp,
	  exit_balance decimal(10,2),
	  exit_fee_time_length integer,
	  certificate_pic varchar(200),
	  exit_should_charge decimal(10,2),
	  period_multi_start timestamp,
	  period_multi_received decimal(10,2),
	  period_multi_free decimal(10,2),
	  next_period_multi_start timestamp,
	  next_period_multi_cur decimal(10,2),
	  exit_fee_start_time timestamp,
	  discount_money decimal(10,2),
	  already_paid decimal(10,2),
	  already_paid_method smallint,
	  already_paid_scene smallint,
	  cash_pay decimal(10,2),
	  deduct_money decimal(10,2),
	  record_state smallint,
	  carpark_id integer NOT NULL,
	  project_id integer NOT NULL,
	  discount_times smallint, 
	  discount_project_no varchar(45),
      discount_project_name varchar(45),
      discount_merchant_type smallint,
      discount_merchant_no varchar(45),
      discount_merchant_name varchar(45),
      take_plate_number varchar(20),
      take_enter_time timestamp,
      take_passport_type_no varchar(45),
      secret_free_payment smallint,
      pass_state_value smallint,
      discount_method smallint,
      discount_value integer,
      discount_source smallint,
      already_paid_times smallint, 
      already_paid_charge_org smallint,
      already_paid_time timestamp,
      discount_time timestamp,
	  PRIMARY KEY (id)
);

-- version 167 cs
CREATE INDEX ck_carpark_cancel_pass_record_index_001 ON ck_carpark_cancel_pass_record (pass_time);

-- version 168 cs
CREATE TABLE IF NOT EXISTS ck_carpark_discount_project_sync(
   id bigint NOT NULL,
   discount_project_no varchar(45) NOT NULL,
   discount_project_name varchar(45) NOT NULL,
   discount_method smallint NOT NULL,
   discount_value integer NOT NULL,
   use_type integer NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 169 cs
DROP TRIGGER IF EXISTS ck_carpark_discount_project_sync_log_trigger ON ck_carpark_discount_project_sync;

-- version 170 cs
CREATE TRIGGER ck_carpark_discount_project_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_discount_project_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 171 cs
CREATE TABLE IF NOT EXISTS ck_carpark_merchant(
   id bigint NOT NULL,  
   merchant_no varchar(45) NOT NULL,
   merchant_name varchar(45) NOT NULL,
   merchant_addr varchar(200), 
   merchant_type smallint NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 172 cs
CREATE INDEX ck_carpark_merchant_index_001 ON ck_carpark_merchant (merchant_no);

-- version 173 cs
CREATE TABLE IF NOT EXISTS ck_carpark_merchant_user(
   id bigint NOT NULL,
   user_no varchar(45) NOT NULL,
   user_phone varchar(20) NOT NULL,
   user_name varchar(45) NOT NULL,
   user_pwd varchar(32) NOT NULL,
   merchant_no varchar(45) NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 174 cs
CREATE INDEX ck_carpark_merchant_user_index_001 ON ck_carpark_merchant_user (merchant_no);

-- version 175 cs
CREATE INDEX ck_carpark_merchant_user_index_002 ON ck_carpark_merchant_user (user_phone);

-- version 176 cs
CREATE TABLE IF NOT EXISTS ck_carpark_merchant_coupon_proj(
   id bigint NOT NULL,
   coupon_proj_no varchar(45) NOT NULL,
   coupon_proj_name varchar(45) NOT NULL,
   discount_method smallint NOT NULL,
   discount_value integer NOT NULL,
   merchant_no varchar(45) NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 177 cs
CREATE INDEX ck_carpark_merchant_coupon_proj_index_001 ON ck_carpark_merchant_coupon_proj (merchant_no);

-- version 178 cs
CREATE TABLE IF NOT EXISTS ck_carpark_merchant_coupon_rule(
   id bigint NOT NULL,
   rule_no varchar(45) NOT NULL,
   coupon_proj_no varchar(45) NOT NULL,
   purchase_quantity integer NOT NULL,
   purchase_amount decimal(10,2) NOT NULL,   
   valid_days integer NOT NULL,
   merchant_no varchar(45) NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 179 cs
CREATE INDEX ck_carpark_merchant_coupon_rule_index_001 ON ck_carpark_merchant_coupon_rule (merchant_no);

-- version 180 cs
CREATE TABLE IF NOT EXISTS ck_carpark_merchant_coupon_order(
   id bigint NOT NULL,
   coupon_order_no varchar(64) NOT NULL,
   coupon_proj_no varchar(45) NOT NULL,
   coupon_proj_name varchar(45),
   discount_method smallint NOT NULL,
   discount_value integer NOT NULL,
   merchant_no varchar(45) NOT NULL,   
   merchant_name varchar(45),
   purchase_quantity integer NOT NULL,
   valid_date timestamp NOT NULL,
   pay_amount decimal(10,2) NOT NULL,   
   pay_time timestamp NOT NULL,
   pay_method smallint NOT NULL,
   pay_scene smallint NOT NULL,
   charge_org smallint NOT NULL,
   pay_entry smallint NOT NULL,
   remain_count integer NOT NULL,
   use_count integer NOT NULL,
   disable_count integer NOT NULL,
   update_counter integer NOT NULL,
   exhaustion_time timestamp NOT NULL,
   order_state smallint NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 181 cs
CREATE INDEX ck_carpark_merchant_coupon_order_index_001 ON ck_carpark_merchant_coupon_order (merchant_no,exhaustion_time);

-- version 182 cs
CREATE UNIQUE INDEX ck_carpark_merchant_coupon_order_index_002 ON ck_carpark_merchant_coupon_order (coupon_order_no);

-- version 183 cs
CREATE TABLE IF NOT EXISTS ck_carpark_merchant_coupon_use_record(
   id bigint NOT NULL,
   coupon_no varchar(45),
   coupon_order_no varchar(64) NOT NULL,
   coupon_proj_no varchar(45),
   coupon_proj_name varchar(45),
   merchant_no varchar(45) NOT NULL,   
   merchant_name varchar(45),
   discount_method smallint NOT NULL,
   discount_value integer NOT NULL,
   use_plate varchar(20),
   merchant_phone_no varchar(20),
   merchant_user_name varchar(45),
   use_time timestamp,
   area_no varchar(45),
   enter_time timestamp,
   enter_record_no varchar(45),
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id)
);

-- version 184 cs
CREATE INDEX ck_carpark_merchant_coupon_use_record_index_001 ON ck_carpark_merchant_coupon_use_record (coupon_order_no);

-- version 185 cs
CREATE TABLE IF NOT EXISTS ck_carpark_pass_discount(
  id bigint NOT NULL,
  discount_no varchar(45) NOT NULL,
  discount_time timestamp NOT NULL,
  enter_record_no varchar(45),
  palte_number varchar(20),
  enter_time timestamp NOT NULL,
  passport_number varchar(64) NOT NULL,
  medium_type smallint NOT NULL,  
  coupon_no varchar(45),
  coupon_order_no varchar(64),
  discount_project_no varchar(45),
  discount_project_name varchar(45),
  discount_merchant_type smallint,
  discount_merchant_no varchar(45),
  discount_merchant_name varchar(45),
  discount_method smallint NOT NULL,
  discount_value integer NOT NULL,
  discount_value_des varchar(100),
  discount_source smallint,
  operation_user_code varchar(45),
  operation_user_name varchar(45),
  created_time timestamp NOT NULL,
  carpark_id integer NOT NULL, 
  project_id integer NOT NULL,
  PRIMARY KEY (id)
);

-- version 186 cs
CREATE INDEX ck_carpark_pass_discount_index_001 ON ck_carpark_pass_discount (passport_number,enter_time);

-- version 187 cs
CREATE TABLE IF NOT EXISTS ck_carpark_discount_record(
  id bigint NOT NULL,
  discount_no varchar(45) NOT NULL,
  discount_time timestamp NOT NULL,
  enter_record_no varchar(45),
  palte_number varchar(20),  
  enter_time timestamp,
  passport_number varchar(64),
  medium_type smallint,  
  coupon_no varchar(45),
  coupon_order_no varchar(64),
  discount_project_no varchar(45),
  discount_project_name varchar(45),
  discount_merchant_type smallint,
  discount_merchant_no varchar(45),
  discount_merchant_name varchar(45),
  discount_method smallint,
  discount_value integer,  
  discount_source smallint, 
  operation_user_code varchar(45),
  operation_user_name varchar(45),
  created_time timestamp NOT NULL,
  carpark_id integer NOT NULL, 
  project_id integer NOT NULL,
  discount_value_des varchar(100),
  passport_type_no varchar(45),
  passport_type_name varchar(45),
  certificate_pic varchar(200),  
  exit_time timestamp,
  exit_record_no varchar(45),
  PRIMARY KEY (id)
);

-- version 188 cs
CREATE INDEX ck_carpark_discount_record_index_001 ON ck_carpark_discount_record (discount_time);

-- version 189 cs
CREATE SEQUENCE ck_carpark_discount_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 190 cs
CREATE INDEX ck_carpark_discount_record_index_002 ON ck_carpark_discount_record (discount_no);

-- version 191 cs
CREATE TABLE IF NOT EXISTS ck_carpark_pass_self_pay(
  id bigint NOT NULL,
  paid_amount decimal(10,2) NOT NULL,
  paid_method smallint NOT NULL,
  pay_scene smallint NOT NULL,
  charge_org smallint NOT NULL,
  pay_entry smallint NOT NULL,
  paid_time timestamp NOT NULL,
  plan_leave_time timestamp NOT NULL,
  passport_number varchar(64) NOT NULL,
  medium_type smallint NOT NULL,
  enter_time timestamp NOT NULL,
  charge_start_time timestamp NOT NULL,
  plate_number varchar(20),
  enter_record_no varchar(45),
  should_charge decimal(10,2),
  discount_money decimal(10,2),
  already_paid decimal(10,2),
  period_multi_start timestamp,
  period_multi_received decimal(10,2),
  period_multi_free decimal(10,2),
  next_period_multi_start timestamp,
  next_period_multi_cur decimal(10,2),
  charge_time_length integer,
  cloud_order_no varchar(64),
  charge_record_no varchar(45),
  created_time timestamp NOT NULL,
  carpark_id integer NOT NULL, 
  project_id integer NOT NULL,
  duty_no varchar(45),
  PRIMARY KEY (id)
);

-- version 192 cs
CREATE INDEX ck_carpark_pass_self_pay_index_001 ON ck_carpark_pass_self_pay (passport_number,enter_time);

-- version 193 cs
CREATE INDEX ck_carpark_transaction_index_002 ON ck_carpark_transaction (passport_number,enter_time);

-- version 194 cs 
CREATE TABLE IF NOT EXISTS ck_carpark_illegal_pass_record(
    id bigint NOT NULL,
    record_no varchar(45) NOT NULL,
    pass_time timestamp NOT NULL,
    pass_plate varchar(20),   
    channel_no varchar(45),
    channel_name varchar(45),
    area_no varchar(45),
    area_name varchar(45),
    record_type smallint,
    reason_code varchar(45),
    description varchar(100),
    host_no varchar(45),
    host_name varchar(45),
	op_user_code varchar(45),
	op_user_name varchar(45),
	pic_path varchar(200),
	carpark_id integer NOT NULL, 
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 195 cs
CREATE INDEX ck_carpark_illegal_pass_record_index_001 ON ck_carpark_illegal_pass_record (pass_time);

-- version 196 cs
CREATE SEQUENCE ck_carpark_illegal_pass_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 197 cs
CREATE INDEX ck_carpark_duty_number_index_003 ON ck_carpark_duty_number (login_duty_user_code,start_time);

-- version 198 cs
CREATE TABLE IF NOT EXISTS ck_carpark_tran_config_sync(
     id bigint NOT NULL,
     tran_config_key smallint NOT NULL,
     tran_config_value varchar(100) NOT NULL,
     tran_config_type smallint NOT NULL,
     created_time timestamp NOT NULL,
     last_updated_time timestamp NOT NULL,
     carpark_id integer NOT NULL,
     project_id integer NOT NULL,
	 PRIMARY KEY (id)
);

-- version 199 cs
CREATE INDEX ck_carpark_tran_config_sync_index_001 ON ck_carpark_tran_config_sync (tran_config_type,tran_config_key);

-- version 200 cs
DROP TRIGGER IF EXISTS ck_carpark_tran_config_sync_log_trigger ON ck_carpark_tran_config_sync;

-- version 201 cs 
CREATE TRIGGER ck_carpark_tran_config_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_tran_config_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 202 cs
CREATE INDEX ck_carpark_discount_record_index_003 ON ck_carpark_discount_record (passport_number,enter_time);

-- version 203 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN remove_user_code varchar(45);

-- version 204 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN remove_user_name varchar(45);

-- version 205 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN remove_enter_time timestamp;

-- version 206 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN remove_op_time timestamp;

-- version 207 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN remove_user_code varchar(45);

-- version 208 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN remove_user_name varchar(45);

-- version 209 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN remove_enter_time timestamp;

-- version 210 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN remove_op_time timestamp;

-- version 211 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN remove_user_code varchar(45);

-- version 212 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN remove_user_name varchar(45);

-- version 213 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN remove_enter_time timestamp;

-- version 214 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN remove_op_time timestamp;

-- version 215 cs
CREATE TABLE IF NOT EXISTS ck_carpark_fee_report(
	id bigint NOT NULL,
    year smallint,
    quarter smallint,
    month smallint,
    day smallint,
	report_date date,
	tran_area_no varchar(45),
	operate_user_code varchar(45),
	host_no varchar(45),
	passport_type_no varchar(45),
	car_type_no varchar(45),
	pass_type smallint,
	service_type smallint,
	pay_method smallint,
    pay_scene smallint,
    charge_org smallint,
    tran_money numeric(12,2),
	carpark_id integer NOT NULL,
    project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 216 cs
CREATE INDEX ck_carpark_fee_report_index_001 ON ck_carpark_fee_report (report_date);


-- version 217 cs
CREATE TABLE IF NOT EXISTS ck_carpark_car_count_report(
    id bigint NOT NULL,
	report_date date,
	pass_type smallint,
	passport_type_no varchar(45),
	car_type_no varchar(45),
	report_hour smallint,
	reg_count integer,
	car_count integer,
	expire_count integer,
	carpark_id integer NOT NULL,
    project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 218 cs
CREATE INDEX ck_carpark_car_count_report_index_001 ON ck_carpark_car_count_report (report_date);

-- version 219 cs
ALTER TABLE ck_carpark_sync ADD COLUMN bind_cloud smallint;

-- version 220 cs
ALTER TABLE ck_carpark_sync ALTER COLUMN cloud_carpark_sign_key TYPE varchar(100);

-- version 221 cs
ALTER TABLE ck_carpark_transaction ADD COLUMN invoice_status smallint DEFAULT 0;

-- version 222 cs
ALTER TABLE ck_carpark_transaction ADD COLUMN invoice_cloud_no varchar(64);

-- version 223 cs
ALTER TABLE ck_carpark_merchant_coupon_use_record ADD COLUMN order_created_time timestamp NOT NULL;

-- version 224 cs
CREATE TABLE IF NOT EXISTS ck_carpark_query_fee(
  id bigint NOT NULL,
  query_time timestamp NOT NULL,
  passport_number varchar(64) NOT NULL,
  medium_type smallint NOT NULL,
  enter_time timestamp NOT NULL,
  charge_start_time timestamp NOT NULL,
  plate_number varchar(20),
  enter_record_no varchar(45),
  should_charge decimal(10,2),
  actual_charge_amount decimal(10,2) NOT NULL,
  discount_money decimal(10,2),
  already_paid decimal(10,2),
  period_multi_start timestamp,
  period_multi_received decimal(10,2),
  period_multi_free decimal(10,2),
  next_period_multi_start timestamp,
  next_period_multi_cur decimal(10,2),
  charge_time_length integer,
  operate_user_code varchar(45),
  operate_user_name varchar(45),
  host_no varchar(45),
  host_name varchar(45),
  duty_no varchar(45),
  carpark_id integer NOT NULL, 
  project_id integer NOT NULL,
  passport_no varchar(45),
  pass_type smallint, 
  passport_type_no varchar(45),
  passport_type_name varchar(45),
  car_type_no varchar(45),
  car_type_name varchar(45),
  tran_area_no varchar(45),
  tran_area_name varchar(45),
  tran_channel_no varchar(45),
  tran_channel_name varchar(45),
  tran_user_no varchar(64),
  tran_user_name varchar(45),
  PRIMARY KEY (id)
);

-- version 225 cs
CREATE SEQUENCE ck_carpark_query_fee_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 226 cs
CREATE TABLE IF NOT EXISTS ck_carpark_cloud_order_message(
    id bigint NOT NULL,
    order_no varchar(64) NOT NULL,
    name varchar(64) NOT NULL,
    created_time timestamp NOT NULL,
    carpark_id integer NOT NULL, 
    project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 227 cs
CREATE UNIQUE INDEX ck_carpark_cloud_order_message_index_001 ON ck_carpark_cloud_order_message (order_no,name);

-- version 228 cs
CREATE TABLE IF NOT EXISTS ck_carpark_invoice_order(
    id bigint NOT NULL,
    invoice_cloud_no varchar(45) NOT NULL,
    invoice_order_no varchar(45) NOT NULL,
    project_id integer NOT NULL,
    carpark_id integer NOT NULL,
    api_code varchar(45),
    buyer_name varchar(200),
    buyer_identity_no varchar(32),
    buyer_bank_no varchar(100),
    buyer_address_phone varchar(100),
    buyer_email varchar(100),
    buyer_phone varchar(20),
    buyer_plate_number varchar(20), 
    project_name varchar(200),
    project_type varchar(50),
    project_unit varchar(50),
    project_count decimal(12,6),
    project_price decimal(10,2),
    project_amount decimal(10,2),
    project_rate decimal(10,5),
    project_rate_money decimal(10,2),
    project_rate_amount decimal(10,2),
    seller_name varchar(200),
    seller_identity_no varchar(32),
    seller_bank_no varchar(100),
    seller_address_phone varchar(100),
    seller_remarks varchar(200),
    seller_payer varchar(50),
    seller_checker varchar(50),
    seller_invicer varchar(50),
    status smallint,
    ticket_no varchar(64),
    ticket_code varchar(32),
    ticket_sn varchar(32),
    pdf_url varchar(300),
    pdf_key varchar(200),
    pic_url varchar(200),
    created_time timestamp,
    invoice_success_time timestamp,
    flush_red_status smallint,
    flush_red_pdf varchar(300),
    flush_red_no varchar(64),
    flush_red_time timestamp ,
    flush_red_code varchar(32),
    tran_count integer,
    PRIMARY KEY (id)
);

-- version 229 cs
CREATE UNIQUE INDEX ck_carpark_invoice_order_index_001 ON ck_carpark_invoice_order (invoice_order_no);

-- version 230 cs
CREATE INDEX ck_carpark_invoice_order_index_002 ON ck_carpark_invoice_order (invoice_cloud_no);

-- version 240 cs
CREATE INDEX ck_carpark_invoice_order_index_003 ON ck_carpark_invoice_order (invoice_success_time);

-- version 241 cs
CREATE TABLE IF NOT EXISTS ck_carpark_visit_auth_sync(
    id bigint NOT NULL,
    visit_auth_no varchar(45) NOT NULL,
    passport_type_no varchar(45) NOT NULL,
    passport_type_name varchar(45),
    auth_times smallint NOT NULL DEFAULT 1,
    pass_times smallint NOT NULL DEFAULT 0,
    plate_number varchar(20) NOT NULL,
    visit_date date NOT NULL,
    visit_begin_time timestamp NOT NULL,
    visit_end_time timestamp NOT NULL,
    visit_area_no varchar(45) NOT NULL,
    visit_area_name varchar(45),
    visit_name varchar(45),
    visit_phone varchar(45),
    visit_id_no varchar(45),
    visit_company varchar(200),
    visit_reason varchar(200),
    recep_name varchar(45),
    recep_phone varchar(45),
    recep_company varchar(200),
    remark varchar(200),
    status smallint NOT NULL,
    op_user_code varchar(45),
    op_user_name varchar(45),
    stype smallint NOT NULL,
    enter_time timestamp,
    enter_channel_no varchar(45),
    enter_channel_name varchar(45),
    created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 242 cs
CREATE INDEX ck_carpark_visit_auth_sync_index_001 ON ck_carpark_visit_auth_sync (plate_number);

-- version 243 cs
DROP TRIGGER IF EXISTS ck_carpark_visit_auth_sync_log_trigger ON ck_carpark_visit_auth_sync;

-- version 244 cs
CREATE TRIGGER ck_carpark_visit_auth_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON ck_carpark_visit_auth_sync FOR EACH ROW EXECUTE PROCEDURE ck_ddl_sync_log_trigger();

-- version 245 cs
CREATE TABLE IF NOT EXISTS ck_carpark_visit_auth_record(
    id bigint NOT NULL,
    visit_auth_no varchar(45) NOT NULL,
    passport_type_no varchar(45) NOT NULL,
    passport_type_name varchar(45),
    auth_times smallint NOT NULL DEFAULT 1,
    pass_times smallint NOT NULL DEFAULT 0,
    plate_number varchar(20) NOT NULL,
    visit_date date NOT NULL,
    visit_begin_time timestamp NOT NULL,
    visit_end_time timestamp NOT NULL,
    visit_area_no varchar(45) NOT NULL,
    visit_area_name varchar(45),
    visit_name varchar(45),
    visit_phone varchar(45),
    visit_id_no varchar(45),
    visit_company varchar(200),
    visit_reason varchar(200),
    recep_name varchar(45),
    recep_phone varchar(45),
    recep_company varchar(200),
    remark varchar(200),
    status smallint NOT NULL,
    op_user_code varchar(45),
    op_user_name varchar(45),
    stype smallint NOT NULL,
    enter_time timestamp,
    enter_channel_no varchar(45),
    enter_channel_name varchar(45),
    created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 246 cs
CREATE INDEX ck_carpark_visit_auth_record_index_001 ON ck_carpark_visit_auth_record (visit_date,plate_number);

-- version 247 cs
CREATE INDEX ck_carpark_visit_auth_record_index_002 ON ck_carpark_visit_auth_record (visit_auth_no);

-- version 248 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN visit_auth_no varchar(45);

-- version 249 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN visit_auth_no varchar(45);

-- version 250 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN visit_auth_no varchar(45);

-- version 251 cs
CREATE TABLE IF NOT EXISTS ck_carpark_third_comm_config(
	id bigint NOT NULL,
	third_comm_code varchar(64) NOT NULL,
	third_comm_name varchar(100) NOT NULL,
	config_key varchar(64) NOT NULL,
	config_key_name varchar(100),
	config_value varchar(255),
	config_value_des varchar(200),
	created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 252 cs
CREATE INDEX ck_carpark_third_comm_config_index_001 ON ck_carpark_third_comm_config (third_comm_code,config_key);

-- version 254 cs
ALTER TABLE ck_carpark_local_config ADD COLUMN cloud_host_id varchar(100);

-- version 255 cs
ALTER TABLE ck_carpark_local_config ADD COLUMN cloud_carpark_sign_key varchar(100);

-- version 258 cs
CREATE SEQUENCE ck_carpark_local_pass_data_cache_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 259 cs
CREATE TABLE IF NOT EXISTS ck_carpark_local_pass_data_cache(
	id bigint NOT NULL,
	pass_save_data varchar(6000) NOT NULL,
	created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    carpark_id integer NOT NULL,
    project_id integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 260 cs
ALTER TABLE ck_carpark_sync ADD COLUMN cartype_script varchar(2000);

-- version 261 cs
ALTER TABLE ck_carpark_local_config ADD COLUMN hide_pwd varchar(64);

-- version 262 cs
ALTER TABLE ck_carpark_sync ALTER COLUMN cartype_script TYPE varchar(6000);

-- version 263 cs
CREATE TABLE IF NOT EXISTS ck_carpark_senseless_pay(
    id bigint NOT NULL,
    plate_number varchar(20) NOT NULL,
    contract_type smallint NOT NULL,
    enter_time timestamp NOT NULL,
    created_time timestamp NOT NULL,
    carpark_id integer NOT NULL, 
    project_id integer NOT NULL,
    PRIMARY KEY (id)
);

-- version 264 cs
CREATE INDEX ck_carpark_senseless_pay_index_001 ON ck_carpark_senseless_pay (plate_number);

-- version 265 cs
CREATE SEQUENCE ck_carpark_senseless_pay_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 266 cs
ALTER TABLE ck_carpark_local_pass_data_cache ALTER COLUMN pass_save_data TYPE varchar(10000);

-- version 267 cs
ALTER TABLE ck_carpark_channel_sync ADD COLUMN slave_managed_host_no varchar(45) NOT NULL DEFAULT '';

-- version 268 cs
ALTER TABLE ck_carpark_local_config ADD COLUMN carpark_deploy_type smallint NOT NULL DEFAULT 0;

-- version 269 cs
ALTER TABLE ck_carpark_local_config ADD COLUMN org_id integer NOT NULL DEFAULT 0;

-- version 270 cs
ALTER TABLE ck_carpark_local_config ADD COLUMN host_type smallint NOT NULL DEFAULT 1;

-- version 271 cs
CREATE TABLE IF NOT EXISTS ck_carpark_ddl_sync_table_log(
    id bigint NOT NULL,
	table_name varchar(100) NOT NULL,
	latest_sync_log_id bigint NOT NULL DEFAULT 0,
	latest_sync_log_time timestamp NOT NULL,
	carpark_id integer NOT NULL, 
    project_id integer NOT NULL,
	PRIMARY KEY (id)	
);

-- version 272 cs
CREATE UNIQUE INDEX ck_carpark_ddl_sync_table_log_index_001 ON ck_carpark_ddl_sync_table_log (carpark_id,table_name);

-- version 273 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN created_time timestamp;

-- version 274 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN created_time timestamp;

-- version 275 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN created_time timestamp;

-- version 276 cs
ALTER TABLE ck_carpark_regplate_record ADD COLUMN features varchar(500);

-- version 283 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN enter_car_body_pic varchar(200);

-- version 284 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN enter_car_trail_pic varchar(200);

-- version 285 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN enter_car_body_pic varchar(200);

-- version 286 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN enter_car_trail_pic varchar(200);

-- version 287 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN enter_car_body_pic varchar(200);

-- version 288 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN enter_car_trail_pic varchar(200);

-- version 289 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN exit_car_body_pic varchar(200);

-- version 290 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN exit_car_trail_pic varchar(200);

-- version 291 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN exit_car_body_pic varchar(200);

-- version 292 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN exit_car_trail_pic varchar(200);

-- version 293 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN exit_car_body_pic varchar(200);

-- version 294 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN exit_car_trail_pic varchar(200);

-- version 295 cs
ALTER TABLE ck_carpark_query_fee ADD COLUMN enter_pay smallint;

-- version 296 cs
CREATE UNIQUE INDEX ck_carpark_visit_auth_sync_index_002 ON ck_carpark_visit_auth_sync (visit_auth_no);

-- version 297 cs
ALTER TABLE ck_carpark_car_owner_sync ADD COLUMN account_balance decimal(10,2) NOT NULL DEFAULT 0;

-- version 298 cs
ALTER TABLE ck_carpark_discount_record ADD COLUMN discount_amount decimal(10,2);

-- version 299 cs
ALTER TABLE ck_carpark_pass_discount ADD COLUMN discount_amount decimal(10,2);

-- version 300 cs
ALTER TABLE ck_carpark_pass_self_pay ADD COLUMN discounts_json varchar(6000);

-- version 301 cs
ALTER TABLE ck_carpark_query_fee ADD COLUMN discounts_json varchar(6000);

-- version 302 cs
ALTER TABLE ck_carpark_senseless_pay ADD COLUMN credit_support smallint;

-- version 303 cs
ALTER TABLE ck_carpark_sync ADD COLUMN data_sign varchar(100);

-- version 304 cs
ALTER TABLE ck_carpark_illegal_pass_record ADD COLUMN direction smallint;

-- version 305 cs
ALTER TABLE ck_carpark_illegal_pass_record ADD COLUMN area_level smallint;

-- version 306 cs
CREATE TABLE IF NOT EXISTS ck_carpark_escape_order(
	  id bigint NOT NULL,
	  passport_no varchar(45),
	  enter_record_no varchar(45) NOT NULL,
	  exit_record_no varchar(45) NOT NULL,
	  passport_number varchar(64) NOT NULL,
	  medium_type smallint,
	  pass_plate varchar(20),	
	  pass_type smallint,
	  passport_type_no varchar(45),
	  passport_type_name varchar(45),
	  car_owner_no varchar(64),
	  car_owner_name varchar(45),
	  area_no varchar(45),
	  area_level smallint,
	  area_name varchar(45),
	  enter_time timestamp NOT NULL,
	  enter_channel_no varchar(45),
	  enter_channel_name varchar(45),
	  enter_car_pic varchar(200),
	  enter_plate_pic varchar(200),
	  enter_host_no varchar(45),
	  enter_host_name varchar(45),
	  exit_time timestamp NOT NULL,
	  exit_channel_no varchar(45),
	  exit_channel_name varchar(45),
	  exit_car_type_no varchar(45),
	  exit_car_type_name varchar(45),
	  exit_host_no varchar(45),
	  exit_host_name varchar(45),
	  exit_duty_no varchar(45),
	  exit_duty_user_code varchar(45),
	  exit_duty_user_name varchar(45),
	  exit_remark varchar(100),
	  exit_valid_date timestamp,
	  exit_balance decimal(10,2),
	  exit_fee_time_length integer,
	  exit_should_charge decimal(10,2),
	  exit_car_pic varchar(200),
	  exit_plate_pic varchar(200),
	  period_multi_start timestamp,
	  period_multi_received decimal(10,2),
	  period_multi_free decimal(10,2),
	  next_period_multi_start timestamp,
	  next_period_multi_cur decimal(10,2),
	  exit_fee_start_time timestamp,
	  discount_money decimal(10,2),
	  already_paid decimal(10,2),
	  already_paid_method smallint,
	  already_paid_scene smallint,
	  already_paid_times smallint, 
      already_paid_charge_org smallint,
      already_paid_time timestamp,
	  cash_pay decimal(10,2),
	  deduct_money decimal(10,2),
	  created_time timestamp NOT NULL,  
	  order_state smallint NOT NULL DEFAULT 0,
	  order_pay_money decimal(10,2),
	  order_pay_time timestamp,
	  order_pay_method smallint,
	  order_pay_scene smallint,
	  order_charge_org smallint,
	  order_pay_entry smallint,
	  order_des varchar(200),
	  pay_order_no varchar(64),
	  tran_record_no varchar(45),
	  carpark_id integer NOT NULL,
	  project_id integer NOT NULL,
	  PRIMARY KEY (id)
);

-- version 307 cs
CREATE INDEX ck_carpark_escape_order_index_001 ON ck_carpark_escape_order (exit_time);

-- version 308 cs
CREATE INDEX ck_carpark_escape_order_index_002 ON ck_carpark_escape_order (passport_number,exit_time);

-- version 309 cs
ALTER TABLE ck_carpark_query_fee ADD COLUMN exit_time timestamp;

-- version 310 cs
ALTER TABLE ck_carpark_query_fee ADD COLUMN exit_record_no varchar(45);

-- version 311 cs
ALTER TABLE ck_carpark_pass_self_pay ADD COLUMN exit_time timestamp;

-- version 312 cs
ALTER TABLE ck_carpark_pass_self_pay ADD COLUMN exit_record_no varchar(45);

-- version 313 cs
ALTER TABLE ck_carpark_pass_self_pay ADD COLUMN enter_pay smallint;

-- version 314 cs
ALTER TABLE ck_carpark_transaction ADD COLUMN exit_time timestamp;

-- version 315 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN occupy_space_reg_no varchar(45);

-- version 316 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN occupy_plate varchar(45);

-- version 317 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN occupy_end_time timestamp;

-- version 318 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN occupy_passport_type_no varchar(45);

-- version 319 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN change_plate varchar(45);

-- version 320 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN change_enter_time timestamp;

-- version 321 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN change_pass_type_no varchar(45);

-- version 322 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN occupy_space_reg_no varchar(45);

-- version 323 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN occupy_plate varchar(45);

-- version 324 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN occupy_end_time timestamp;

-- version 325 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN occupy_passport_type_no varchar(45);

-- version 326 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN change_plate varchar(45);

-- version 327 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN change_enter_time timestamp;

-- version 328 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN change_pass_type_no varchar(45);

-- version 329 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN occupy_space_reg_no varchar(45);

-- version 330 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN occupy_plate varchar(45);

-- version 331 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN occupy_end_time timestamp;

-- version 332 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN occupy_passport_type_no varchar(45);

-- version 333 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN change_plate varchar(45);

-- version 334 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN change_enter_time timestamp;

-- version 335 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN change_pass_type_no varchar(45);

-- version 336 cs
CREATE INDEX ck_carpark_cancel_pass_record_index_002 ON ck_carpark_cancel_pass_record (passport_number,pass_time);

-- version 337 cs
ALTER TABLE ck_carpark_local_pass_data_cache ALTER COLUMN pass_save_data TYPE varchar(20000);

-- version 338 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN has_unpaid_order smallint;

-- version 339 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN has_unpaid_order smallint;

-- version 340 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN has_unpaid_order smallint;

-- version 341 cs
ALTER TABLE ck_carpark_cancel_pass_record ADD COLUMN remark_data varchar(300);

-- version 342 cs
ALTER TABLE ck_carpark_pass_record ADD COLUMN remark_data varchar(300);

-- version 343 cs
ALTER TABLE ck_carpark_presence_record ADD COLUMN remark_data varchar(300);

-- version 344 cs
ALTER TABLE ck_carpark_discount_project_sync ADD COLUMN settle_method smallint NOT NULL DEFAULT 0;

-- version 345 cs
ALTER TABLE ck_carpark_visit_auth_sync ADD COLUMN priority_value integer NOT NULL DEFAULT 0;

-- version 346 cs
ALTER TABLE ck_carpark_visit_auth_record ADD COLUMN priority_value integer NOT NULL DEFAULT 0;

-- version 347 cs
ALTER TABLE ck_carpark_regplate_record ADD COLUMN camera_reg_time bigint NOT NULL DEFAULT 0;

-- version 348 cs
UPDATE ck_carpark_regplate_record SET camera_reg_time=CAST(EXTRACT(EPOCH FROM reg_time AT TIME ZONE 'UTC-8')*1000 AS BIGINT) WHERE id>0 AND camera_reg_time=0;

-- version 349 cs
CREATE INDEX ck_carpark_regplate_record_index_002 ON ck_carpark_regplate_record (camera_reg_time);

-- version 350 cs
CREATE TABLE IF NOT EXISTS ck_carpark_alarm_event(
   id bigint NOT NULL,
   alarm_ref_id bigint NOT NULL,
   alarm_start_time timestamp NOT NULL,
   alarm_start_device_time timestamp,
   alarm_type smallint NOT NULL, 
   alarm_status smallint NOT NULL,
   alarm_type_id bigint NOT NULL,
   alarm_times integer NOT NULL,
   alarm_start_pic_path varchar(200),
   alarm_latest_time timestamp NOT NULL,
   alarm_latest_device_time timestamp,
   alarm_latest_pic_path varchar(200),
   alarm_level smallint NOT NULL,
   alarm_release_time timestamp,
   alarm_release_pic_path varchar(200),
   alarm_small_pic_path varchar(200),
   host_no varchar(45),
   device_no varchar(45),
   channel_no varchar(45),   
   plate_number varchar(30),   
   upload_cloud_event_id bigint,
   upload_cloud_time timestamp,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id) 
);

-- version 351 cs
CREATE SEQUENCE ck_carpark_alarm_event_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 4294967294 START WITH 1 CACHE 1 CYCLE;

-- version 352 cs
CREATE INDEX ck_carpark_alarm_event_index_001 ON ck_carpark_alarm_event (alarm_start_time);

-- version 353 cs
CREATE INDEX ck_carpark_pass_record_index_003 ON ck_carpark_pass_record (pass_plate);

-- version 357 cs
CREATE INDEX ck_carpark_pass_self_pay_index_002 ON ck_carpark_pass_self_pay (paid_time);

-- version 361 cs
CREATE INDEX ck_carpark_pass_discount_index_002 ON ck_carpark_pass_discount (discount_time);

-- version 381 cs
CREATE TABLE IF NOT EXISTS ck_carpark_space_adjustment(
   id bigint NOT NULL,
   area_no varchar(45) NOT NULL,
   present_adjust integer NOT NULL,
   adjust_remain_spaces integer NOT NULL,
   adjust_time timestamp NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   carpark_id integer NOT NULL,
   project_id integer NOT NULL,
   PRIMARY KEY (id) 
);

-- version 382 cs
CREATE INDEX ck_carpark_space_adjustment_index_001 ON ck_carpark_space_adjustment (area_no);

-- version 383 cs
ALTER TABLE ck_carpark_space_adjustment ADD COLUMN space_type_no varchar(45) NOT NULL DEFAULT '';




