--  vacuumdb -d yourdbname -f -z -v 
--  format: version increment c|s|cs end  

-- version 1 cs
SET client_encoding = 'UTF8';
       
-- version 2 cs       
CREATE TABLE IF NOT EXISTS parking_operation_sync_log(
	id bigint NOT NULL,
	table_name varchar(64) NOT NULL,
	table_pk_name varchar(32) NOT NULL,
	table_pk_value bigint NOT NULL,
	operation char(1) NOT NULL,
	operation_time timestamp NOT NULL,
	operation_user varchar(100),
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 3 cs
CREATE SEQUENCE parking_operation_sync_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 4 cs
CREATE INDEX parking_operation_sync_log_index_001 ON parking_operation_sync_log (table_name,operation_time);


-- version 5 cs
CREATE TABLE IF NOT EXISTS parking_sync_table(
	table_name varchar(64) NOT NULL,
	table_pk_name varchar(32) NOT NULL DEFAULT 'id',
	last_operation_time timestamp NOT NULL DEFAULT timestamp '1900-01-01 00:00:00',
	last_operation_log_id bigint NOT NULL DEFAULT 0,
	last_delete_log_time timestamp NOT NULL DEFAULT timestamp '1900-01-01 00:00:00',
	last_delete_log_id bigint NOT NULL DEFAULT 0,
	last_syn_time timestamp NOT NULL DEFAULT timestamp '1900-01-01 00:00:00',
	last_syn_log_id bigint NOT NULL DEFAULT 0,
	attr1 varchar(50),
	attr2 varchar(50),
	attr3 varchar(100),
	attr4 varchar(100),
	attr5 varchar(200),
	attr6 varchar(200),
	product_service_id bigint NOT NULL
);

-- 注意如果是云集群,应该是 PRIMARY KEY(product_service_id,table_name)
-- version 6 c
ALTER TABLE parking_sync_table ADD CONSTRAINT parking_sync_table_pkey PRIMARY KEY(table_name);

-- version 7 cs $$;
CREATE OR REPLACE FUNCTION parking_insert_sync_log() RETURNS trigger LANGUAGE plpgsql AS $$
     DECLARE
     d_table_name parking_operation_sync_log.table_name%TYPE;
     d_newlogid parking_operation_sync_log.id%TYPE;
     d_optype parking_operation_sync_log.operation%TYPE;
     d_op_time parking_operation_sync_log.operation_time%TYPE;
     d_id_value parking_operation_sync_log.table_pk_value%TYPE;
     d_user_value parking_operation_sync_log.operation_user%TYPE;
     d_product_service_id parking_operation_sync_log.product_service_id%TYPE;
     BEGIN 
	    d_table_name := TG_RELNAME;
	    d_optype := NULL;
	    d_user_value := NULL;
        IF TG_OP = 'DELETE' THEN
            d_optype :='D';
            d_id_value :=OLD.id;
            d_user_value :=OLD.operation_user;
            d_product_service_id :=OLD.product_service_id;
        ELSIF TG_OP = 'UPDATE' THEN
            d_optype :='U';
            d_id_value :=NEW.id;
            d_user_value :=NEW.operation_user;
            d_product_service_id :=NEW.product_service_id;
        ELSIF TG_OP = 'INSERT' THEN
            d_optype :='I';
            d_id_value :=NEW.id;
            d_user_value :=NEW.operation_user;
            d_product_service_id :=NEW.product_service_id;
        END IF;
        IF (d_optype IS NOT NULL) THEN
          d_newlogid :=nextval('parking_operation_sync_log_seq');
          d_op_time :=now();
          INSERT INTO parking_operation_sync_log (id,table_name,table_pk_name,table_pk_value,operation,operation_time,operation_user,product_service_id)
                  VALUES (d_newlogid,d_table_name,'id',d_id_value,d_optype, d_op_time,d_user_value,d_product_service_id);
          UPDATE parking_sync_table SET last_operation_time=d_op_time, last_operation_log_id=d_newlogid WHERE product_service_id=d_product_service_id AND table_name=d_table_name;
        END IF;
	    
    RETURN NULL;
    END;
$$;


-- version 8 cs 
CREATE TABLE IF NOT EXISTS parking_function (
    id integer NOT NULL,
    function_name varchar(100) NOT NULL,
    description varchar(300) NULL,
    function_type smallint NOT NULL,
    sysem_created smallint DEFAULT 0 NOT NULL,
    created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    operation_user varchar(100) NOT NULL,
    product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);

-- version 9 cs
CREATE SEQUENCE parking_function_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 10 cs
CREATE SEQUENCE parking_pass_type_sync_seq INCREMENT BY 1 MINVALUE 1001 MAXVALUE 2147483647 START WITH 1001 CACHE 1 CYCLE;

-- version 11 cs 
CREATE TABLE IF NOT EXISTS parking_user_sync(
   id integer NOT NULL,
   user_code varchar(100) NOT NULL,
   user_name varchar(100) NOT NULL,
   password varchar(100) NOT NULL,
   role_id integer NOT NULL,
   user_state smallint DEFAULT 0 NOT NULL,
   employee_number varchar(100) NULL,
   user_sex smallint NOT NULL DEFAULT 0,
   phone varchar(100)  NULL,
   department varchar(100) NULL,
   card_number varchar(100) NULL,
   birthday date NULL,
   address varchar(200) NULL,
   photo_uri varchar(200) NULL,
   remark varchar(300) NULL,
   sysem_created smallint DEFAULT 0 NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 12 cs 
CREATE INDEX parking_user_sync_index_001 ON parking_user_sync (user_code);

-- version 13 cs
DROP TRIGGER IF EXISTS parking_user_sync_log_trigger ON parking_user_sync;

-- version 14 s
CREATE TRIGGER parking_user_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_user_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 16 cs 
CREATE SEQUENCE parking_user_sync_seq INCREMENT BY 1 MINVALUE 1001 MAXVALUE 2147483647 START WITH 1001 CACHE 1 CYCLE;

-- version 17 cs
CREATE TABLE IF NOT EXISTS parking_role_sync (
    id integer NOT NULL,
    role_name varchar(100) NOT NULL,
    description varchar(200) NULL,
    sysem_created smallint DEFAULT 0 NOT NULL,
    created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    operation_user varchar(100) NOT NULL,
    product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);  


-- version 19 cs
DROP TRIGGER IF EXISTS parking_role_sync_log_trigger ON parking_role_sync;

-- version 20 s
CREATE TRIGGER parking_role_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_role_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

  
-- version 24 cs 
CREATE SEQUENCE parking_role_sync_seq INCREMENT BY 1 MINVALUE 1001 MAXVALUE 2147483647 START WITH 1001 CACHE 1 CYCLE;

-- version 25 cs
DROP TRIGGER IF EXISTS parking_function_log_trigger ON parking_function;

-- version 26 s
CREATE TRIGGER parking_function_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_function FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 27 cs
CREATE TABLE IF NOT EXISTS parking_role_function_sync (
    id integer NOT NULL,
    role_id integer NOT NULL,
    function_id integer NOT NULL,
    sysem_created smallint DEFAULT 0 NOT NULL,
    created_time timestamp NOT NULL,
    last_updated_time timestamp NOT NULL,
    operation_user varchar(100) NOT NULL,
    product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);


-- version 28 cs
DROP TRIGGER IF EXISTS parking_role_function_sync_log_trigger ON parking_role_function_sync;

-- version 29 s
CREATE TRIGGER parking_role_function_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_role_function_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 30 cs 
CREATE SEQUENCE parking_role_function_sync_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 31 cs
CREATE INDEX parking_role_function_sync_index_001 ON parking_role_function_sync (role_id,function_id);

-- version 32 cs
CREATE TABLE IF NOT EXISTS parking_equipments_sync(
	id integer NOT NULL,
	parent_id integer NOT NULL DEFAULT 0,
	parking_id integer NOT NULL DEFAULT 0,
	equipment_name varchar(100) NOT NULL,
	equipment_description varchar(300) NULL,
	equipment_type smallint NOT NULL,
	equipment_use smallint NOT NULL,
	equipment_driver varchar(100) NULL,
	equipment_manufacturer varchar(100) NULL,
	equipment_model varchar(100) NULL,
	equipment_serial_number varchar(100) NULL,
	equipment_level integer NOT NULL DEFAULT 1,
	disable smallint NOT NULL DEFAULT 0,
	created_time timestamp NOT NULL,
	created_user varchar(100) NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 33 cs
CREATE INDEX parking_equipments_sync_index_001 ON parking_equipments_sync (parent_id);
	
-- version 34 cs
DROP TRIGGER IF EXISTS parking_equipments_sync_log_trigger ON parking_equipments_sync;

-- version 35 s
CREATE TRIGGER parking_equipments_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_equipments_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 36 cs
CREATE SEQUENCE parking_equipments_sync_seq INCREMENT BY 1 MINVALUE 1002 MAXVALUE 2147483647 START WITH 1002 CACHE 1 CYCLE;

-- version 37 cs
CREATE TABLE IF NOT EXISTS parking_equipments_config_sync(
    id integer NOT NULL,
	equipment_id integer NOT NULL,
	config_key varchar(100) NOT NULL,
	config_key_name varchar(100) NULL,
	config_value varchar(100) NULL,
	config_description varchar(300) NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 38 cs
CREATE INDEX parking_equipments_config_sync_index_001 ON parking_equipments_config_sync (equipment_id);

-- version 39 cs
DROP TRIGGER IF EXISTS parking_equipments_config_sync_log_trigger ON parking_equipments_config_sync;

-- version 40 s
CREATE TRIGGER parking_equipments_config_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_equipments_config_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 41 cs
CREATE SEQUENCE parking_equipments_config_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 42 cs
CREATE TABLE IF NOT EXISTS parking_channels_sync(
	id integer NOT NULL,
	channel_name varchar(100) NOT NULL,
	channel_description varchar(300) NULL,
	channel_type smallint NOT NULL DEFAULT 0,
	unattended_mode smallint NOT NULL DEFAULT 1,
	client_release_mode_id integer NOT NULL,
	server_release_mode_id integer NOT NULL,
	handset_release_mode_id integer NOT NULL,
	default_managed_equipment_id integer NOT NULL DEFAULT 0,
	off_in_place_read smallint NOT NULL DEFAULT 0,
	have_car_read_card_near smallint NOT NULL DEFAULT 0,
	have_car_read_card_far smallint NOT NULL DEFAULT 0,
	have_car_read_card_medium smallint NOT NULL DEFAULT 0,
    have_car_read_temp_plate smallint NOT NULL DEFAULT 1,
    channel_number integer NOT NULL,
	disable smallint NOT NULL DEFAULT 0,
	created_time timestamp NOT NULL,
	created_user varchar(100) NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 43 cs
DROP TRIGGER IF EXISTS parking_channels_sync_log_trigger ON parking_channels_sync;

-- version 44 s
CREATE TRIGGER parking_channels_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_channels_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 45 cs
CREATE TABLE IF NOT EXISTS parking_channels_equipments_sync(
	id integer NOT NULL,
	channel_id integer NOT NULL,
	equipment_id integer NOT NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 46 cs
DROP TRIGGER IF EXISTS parking_channels_equipments_sync_log_trigger ON parking_channels_equipments_sync;

-- version 47 s
CREATE TRIGGER parking_channels_equipments_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_channels_equipments_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 48 cs 
CREATE INDEX parking_channels_equipments_sync_index_001 ON parking_channels_equipments_sync (channel_id,equipment_id);

-- version 49 cs
CREATE SEQUENCE parking_channels_equipments_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 50 cs 
CREATE TABLE IF NOT EXISTS parking_areas_sync(
	id integer NOT NULL,
	parent_id integer NOT NULL DEFAULT 0,
	area_name varchar(100) NOT NULL,
	area_description varchar(300) NULL,
	whether_charge smallint NOT NULL DEFAULT 0,
	temporary_quantities integer NOT NULL DEFAULT 0,
	fixed_quantities integer NOT NULL DEFAULT 0,
	special_quantities integer NOT NULL DEFAULT 0,
	area_number integer NOT NULL,
    area_type smallint NOT NULL,
    area_level integer NOT NULL,
    parking_id integer NOT NULL,
	disable smallint NOT NULL DEFAULT 0, 
	created_time timestamp NOT NULL,
	created_user varchar(100) NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);



-- version 51 cs
DROP TRIGGER IF EXISTS parking_areas_sync_log_trigger ON parking_areas_sync;

-- version 52 s 
CREATE TRIGGER parking_areas_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_areas_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 53 cs
CREATE TABLE IF NOT EXISTS parking_channels_areas_sync(
	id integer NOT NULL,
	channel_id integer NOT NULL,
	area_id integer NOT NULL,
	channel_direction smallint NOT NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 54 cs
DROP TRIGGER IF EXISTS parking_channels_areas_sync_log_trigger ON parking_channels_areas_sync;

-- version 55 s 
CREATE TRIGGER parking_channels_areas_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_channels_areas_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 56 cs 
CREATE INDEX parking_channels_areas_sync_index_001 ON parking_channels_areas_sync (channel_id,area_id);

-- version 57 cs 
CREATE SEQUENCE parking_channels_areas_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 58 cs 
CREATE TABLE IF NOT EXISTS parking_pass_type_sync(
	id integer NOT NULL,
	pass_type_name varchar(100) NOT NULL,
	prepaid_type smallint NOT NULL DEFAULT 0,
	paid_type smallint NOT NULL DEFAULT 0,
	paid_mode smallint NOT NULL DEFAULT 0,
	pay_cash_mode integer NOT NULL DEFAULT 0,
	pay_arrears_mode integer NOT NULL DEFAULT 0,
	for_client_type smallint NOT NULL DEFAULT 0, 
	parking_space_type smallint NOT NULL DEFAULT 0,
	use_issuer smallint NOT NULL DEFAULT 0,
	sysem_created smallint DEFAULT 0 NOT NULL,
	created_time timestamp NOT NULL,
	created_user varchar(100) NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	passport_type_number integer NOT NULL,
	PRIMARY KEY (id)
);

-- version 59 cs
DROP TRIGGER IF EXISTS parking_pass_type_sync_log_trigger ON parking_pass_type_sync;

-- version 60 s 
CREATE TRIGGER parking_pass_type_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_pass_type_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 61 cs 
CREATE TABLE IF NOT EXISTS parking_attributes_sync(
    id integer NOT NULL,
    parent_id integer NOT NULL DEFAULT 0,
    attribute_code integer NOT NULL,
    attribute_name varchar(100) NULL,
    attribute_value varchar(100) NOT NULL,
    attribute_description varchar(100) NULL,
    attribute_type smallint NOT NULL,
    sysem_created smallint NOT NULL DEFAULT 0,
    created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 62 cs 
CREATE SEQUENCE parking_attributes_sync_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 63 cs 
CREATE INDEX parking_attributes_sync_index_001 ON parking_attributes_sync (attribute_type,attribute_code);

-- version 64 cs
DROP TRIGGER IF EXISTS parking_attributes_sync_log_trigger ON parking_attributes_sync;

-- version 65 s 
CREATE TRIGGER parking_attributes_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_attributes_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 69 cs
CREATE INDEX parking_attributes_sync_index_002 ON parking_attributes_sync (parent_id);

-- version 71 cs
CREATE TABLE IF NOT EXISTS parking_release_mode_sync(
	id integer NOT NULL,
	mode_name varchar(100) NOT NULL,
	manage_type smallint NOT NULL,
	manage_mode smallint NOT NULL,
	sysem_created smallint NOT NULL DEFAULT 0,
	created_user varchar(100) NOT NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 72 cs 
CREATE SEQUENCE parking_release_mode_sync_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 73 cs 
CREATE INDEX parking_release_mode_sync_index_001 ON parking_release_mode_sync (mode_name);

-- version 74 cs
DROP TRIGGER IF EXISTS parking_release_mode_sync_log_trigger ON parking_release_mode_sync;

-- version 75 s 
CREATE TRIGGER parking_release_mode_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_release_mode_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 88 cs
CREATE INDEX parking_equipments_config_sync_index_002 ON parking_equipments_config_sync (config_key,config_value);

-- version 89 cs
CREATE SEQUENCE parking_areas_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 96 cs
CREATE INDEX parking_areas_sync_index_001 ON parking_areas_sync (parent_id);

-- version 97 cs
CREATE INDEX parking_channels_areas_sync_index_002 ON parking_channels_areas_sync USING btree (area_id);
  
-- version 98 cs  
CREATE TABLE IF NOT EXISTS parking_operation_log(
	id bigint NOT NULL,
	operation_category integer,
	operation_type char(1),
	operation_description varchar(600),
	operation_time timestamp NOT NULL,
	operation_user_name varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);  

-- version 99 cs
CREATE INDEX parking_operation_log_001 ON parking_operation_log (operation_time,operation_user_name);

-- version 102 cs
CREATE SEQUENCE parking_operation_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;


-- version 128 cs
CREATE TABLE IF NOT EXISTS parking_release_mode_event_sync(
	id integer NOT NULL,
	mode_id integer NOT NULL,
	pass_type_id integer NOT NULL,
	direction smallint NOT NULL,
	event_type smallint NOT NULL,
	handle_value smallint NOT NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 129 cs 
CREATE SEQUENCE parking_release_mode_event_sync_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 130 cs 
CREATE INDEX parking_release_mode_event_sync_index_001 ON parking_release_mode_event_sync (mode_id,pass_type_id);

-- version 131 cs
DROP TRIGGER IF EXISTS parking_release_mode_event_sync_log_trigger ON parking_release_mode_event_sync;

-- version 132 s 
CREATE TRIGGER parking_release_mode_event_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_release_mode_event_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 507 cs
CREATE SEQUENCE parking_channels_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 508 cs
CREATE INDEX parking_equipments_sync_index_002 ON parking_equipments_sync (equipment_type,equipment_name);

-- version 515 cs
CREATE INDEX parking_channels_sync_index_001 ON parking_channels_sync (default_managed_equipment_id);

-- version 516 cs
CREATE INDEX parking_areas_sync_index_002 ON parking_areas_sync (parking_id,area_level);



-- version 549 cs
CREATE TABLE IF NOT EXISTS parking_date_range_sync(
	id integer NOT NULL,
	parent_id integer NOT NULL,
	range_type smallint NOT NULL,
	range_begin bigint NOT NULL DEFAULT 0, 
	range_end bigint NOT NULL DEFAULT 0, 
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 550 cs 
CREATE SEQUENCE parking_date_range_sync_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 551 cs
CREATE INDEX parking_date_range_sync_index_001 ON parking_date_range_sync (parent_id);

-- version 552 cs
DROP TRIGGER IF EXISTS parking_date_range_sync_log_trigger ON parking_date_range_sync;

-- version 553 s 
CREATE TRIGGER parking_date_range_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_date_range_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 554 cs
CREATE TABLE IF NOT EXISTS parking_voice_display_sync(
	id integer NOT NULL,
	use_code integer NOT NULL,
	use_type smallint NOT NULL, 
	use_id integer NOT NULL,
	channel_type smallint NOT NULL,
	enter_voice varchar(1000) NULL,
	enter_display varchar(1000) NULL,
	exit_voice varchar(1000) NULL,
	exit_display varchar(1000) NULL,
	description varchar(300) NULL,
	date_range integer NOT NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 555 cs 
CREATE SEQUENCE parking_voice_display_sync_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 556 cs
CREATE INDEX parking_voice_display_sync_index_001 ON parking_voice_display_sync (use_id,use_type);


-- version 557 cs
DROP TRIGGER IF EXISTS parking_voice_display_sync_log_trigger ON parking_voice_display_sync;

-- version 558 s 
CREATE TRIGGER parking_voice_display_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_voice_display_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 559 cs
CREATE TABLE IF NOT EXISTS parking_voice_display_channel_sync(
	id integer NOT NULL,
	channel_id integer NOT NULL,
	voice_display_id integer NOT NULL,
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 560 cs 
CREATE SEQUENCE parking_voice_display_channel_sync_seq INCREMENT BY 1 MINVALUE 101 MAXVALUE 2147483647 START WITH 101 CACHE 1 CYCLE;

-- version 561 cs 
CREATE INDEX parking_voice_display_channel_sync_index_001 ON parking_voice_display_channel_sync (voice_display_id,channel_id);

-- version 562 cs
DROP TRIGGER IF EXISTS parking_voice_display_channel_sync_log_trigger ON parking_voice_display_channel_sync;

-- version 563 s 
CREATE TRIGGER parking_voice_display_channel_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_voice_display_channel_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 573 cs
CREATE TABLE IF NOT EXISTS parking_passport_sync(
    id integer NOT NULL,
    client_id integer NULL,
	passport_number varchar(100) NOT NULL,
	medium_type smallint NOT NULL,
	pass_type_id integer NOT NULL,
	car_type_id integer NOT NULL,
	surface_number varchar(100) NULL,
	register_plate varchar(50) NULL,
	parking_space_type smallint NULL, 
	parking_space_no varchar(100) NULL,
	deduct_way smallint NOT NULL DEFAULT 0,
	account_id integer NULL,
	car_pic varchar(200) NULL,
	car_color_type integer NULL,
	ic_sector varchar(50) NULL,
	ic_key varchar(50) NULL,
	ic_as_id smallint NOT NULL DEFAULT 0,
	passport_state smallint NOT NULL DEFAULT 0,
	deadline timestamp NULL,
    number_times integer NOT NULL DEFAULT 0,
    balance decimal(30,2) NOT NULL DEFAULT 0,
    cash_pledge decimal(30,2) NOT NULL DEFAULT 0,
    arrears_limit decimal(30,2) NOT NULL DEFAULT 0,
    times_limit integer NOT NULL DEFAULT 0,
    remark varchar(300),
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	start_date timestamp NULL,
	PRIMARY KEY (id)
);

-- version 574 cs 
CREATE UNIQUE INDEX parking_passport_sync_index_001 ON parking_passport_sync (passport_number,medium_type);

-- version 575 cs 
CREATE INDEX parking_passport_sync_index_002 ON parking_passport_sync (client_id);

-- version 577 cs 
CREATE SEQUENCE parking_passport_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 578 cs
DROP TRIGGER IF EXISTS parking_passport_sync_log_trigger ON parking_passport_sync;

-- version 579 s 
CREATE TRIGGER parking_passport_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_passport_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 580 cs
CREATE TABLE IF NOT EXISTS parking_last_access_sync(
   id integer NOT NULL,
   passport_number varchar(100) NOT NULL,
   medium_type smallint NOT NULL,
   area_id integer NOT NULL,
   channel_id integer NOT NULL,
   direction smallint NOT NULL,
   access_time timestamp NOT NULL,
   plate varchar(50) NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 581 cs 
CREATE INDEX parking_last_access_sync_index_001 ON parking_last_access_sync (passport_number);

-- version 582 cs 
CREATE SEQUENCE parking_last_access_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 583 cs
DROP TRIGGER IF EXISTS parking_last_access_sync_log_trigger ON parking_last_access_sync;

-- version 584 s 
CREATE TRIGGER parking_last_access_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_last_access_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 585 cs 
CREATE TABLE IF NOT EXISTS parking_client_sync(
   id integer NOT NULL,
   client_no varchar(100) NULL,
   client_name varchar(100) NULL,
   identi_type integer NULL,
   identi_number varchar(100) NULL,
   client_type integer NULL,
   address varchar(200) NULL,
   phone_number varchar(32) NULL,
   email varchar(100) NULL,
   sex smallint NULL,
   head_photo varchar(100) NULL,
   birthday date NULL,
   attribute1 varchar(200) NULL,
   attribute2 varchar(200) NULL,
   attribute3 varchar(200) NULL,
   attribute4 varchar(200) NULL,
   attribute5 varchar(200) NULL,
   attribute6 varchar(200) NULL,
   attribute7 varchar(200) NULL,
   attribute8 varchar(200) NULL,
   attribute9 varchar(200) NULL,
   attribute10 varchar(200) NULL,
   attribute11 varchar(200) NULL,
   attribute12 varchar(200) NULL,
   attribute13 varchar(200) NULL,
   attribute14 varchar(200) NULL,
   attribute15 varchar(200) NULL,
   attribute16 varchar(200) NULL,
   attribute17 varchar(200) NULL,
   attribute18 varchar(200) NULL,
   attribute19 varchar(200) NULL,
   attribute20 varchar(200) NULL,
   attribute21 varchar(200) NULL,
   attribute22 varchar(200) NULL,
   attribute23 varchar(200) NULL,
   attribute24 varchar(200) NULL,
   attribute25 varchar(200) NULL,
   attribute26 varchar(200) NULL,
   attribute27 varchar(200) NULL,
   attribute28 varchar(200) NULL,
   attribute29 varchar(200) NULL,
   attribute30 varchar(200) NULL,
   attribute31 varchar(200) NULL,
   attribute32 varchar(200) NULL,
   attribute33 varchar(200) NULL,
   attribute34 varchar(200) NULL,
   attribute35 varchar(200) NULL,
   attribute36 varchar(200) NULL,
   attribute37 varchar(200) NULL,
   attribute38 varchar(200) NULL,
   attribute39 varchar(200) NULL,
   attribute40 varchar(200) NULL,
   attribute41 varchar(200) NULL,
   attribute42 varchar(200) NULL,
   attribute43 varchar(200) NULL,
   attribute44 varchar(200) NULL,
   attribute45 varchar(200) NULL,
   attribute46 varchar(200) NULL,
   attribute47 varchar(200) NULL,
   attribute48 varchar(200) NULL,
   attribute49 varchar(200) NULL,
   attribute50 varchar(200) NULL,
   remark varchar(300),
   client_state smallint NOT NULL DEFAULT 0,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 586 cs 
CREATE INDEX parking_client_sync_index_001 ON parking_client_sync (client_no);

-- version 587 cs 
CREATE SEQUENCE parking_client_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 588 cs
DROP TRIGGER IF EXISTS parking_client_sync_log_trigger ON parking_client_sync;

-- version 589 s 
CREATE TRIGGER parking_client_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_client_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 590 cs 
CREATE TABLE IF NOT EXISTS parking_account_sync(
   id integer NOT NULL,
   client_id integer NOT NULL,
   account_name varchar(100) NOT NULL,
   account_number varchar(100) NOT NULL,
   account_balance decimal(30,2) NOT NULL DEFAULT 0,
   arrears_limit decimal(30,2) NOT NULL DEFAULT 0,
   account_type smallint NOT NULL DEFAULT 0,
   remark varchar(300),
   account_state smallint NOT NULL DEFAULT 0,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 591 cs 
CREATE INDEX parking_account_sync_index_001 ON parking_account_sync (client_id);

-- version 592 cs 
CREATE SEQUENCE parking_account_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 593 cs
DROP TRIGGER IF EXISTS parking_account_sync_log_trigger ON parking_account_sync;

-- version 594 s 
CREATE TRIGGER parking_account_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_account_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 595 cs 
CREATE TABLE IF NOT EXISTS parking_prepaid_rule_sync(
   id integer NOT NULL,
   pass_type_id integer NOT NULL DEFAULT 0,
   car_type_code integer NOT NULL DEFAULT 0,
   number_times integer NOT NULL DEFAULT 0,
   period_value integer NOT NULL DEFAULT 0,
   period_unit smallint NOT NULL DEFAULT 2,
   prepaid_money decimal(30,2) NOT NULL DEFAULT 0,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 596 cs 
CREATE INDEX parking_prepaid_rule_sync_index_001 ON parking_prepaid_rule_sync (pass_type_id,car_type_code);

-- version 597 cs 
CREATE SEQUENCE parking_prepaid_rule_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 598 cs
DROP TRIGGER IF EXISTS parking_prepaid_rule_sync_log_trigger ON parking_prepaid_rule_sync;

-- version 599 s 
CREATE TRIGGER parking_prepaid_rule_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_prepaid_rule_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 600 cs 
CREATE TABLE IF NOT EXISTS parking_transaction_record
(
  id bigint NOT NULL,
  transaction_type smallint, 
  transaction_subject smallint, 
  transaction_direction smallint, 
  transaction_mode smallint, 
  transaction_money decimal(30,2),
  transaction_time timestamp,
  transaction_operation smallint,
  client_id integer,
  client_number varchar(100),
  client_name varchar(100),
  client_identi_name varchar(100),
  client_identi_number varchar(100),
  account_id integer,
  account_name varchar(100),
  account_number varchar(100),
  account_type smallint,
  account_balance_before decimal(30,2),
  account_balance decimal(30,2),
  transfer_transaction_id bigint,
  transfer_type smallint, 
  register_car_type_id integer,
  register_car_type_name varchar(100),
  passport_type_id integer,
  passport_type_name varchar(100),
  passport_id integer,
  passport_number varchar(100),
  register_plate varchar(100),
  passport_medium_type smallint,
  passport_balance_before decimal(30,2),
  passport_balance decimal(30,2),
  passport_number_times_before integer,
  recharge_number_times integer,
  passport_number_times integer,
  prepay_deadline_before timestamp,
  prepay_start_date timestamp,
  recharge_period_quantity integer,
  recharge_period_unit smallint,
  prepay_end_date timestamp,
  enter_time timestamp,
  exit_time timestamp,
  car_type_id integer,
  car_type_name varchar(100),
  channel_id integer,
  channel_name varchar(100),
  area_id integer,
  area_name varchar(100),
  plate_number varchar(50),
  channel_direction smallint,
  numberofwork_no bigint,
  numberofwork_start_time timestamp,
  numberofwork_end_time timestamp,
  computer_id integer,
  computer_name varchar(100),
  computer_ip varchar(100),
  remote_ip varchar(100),
  operation_app varchar(100),
  center_charge smallint,
  remark varchar(300),
  created_time timestamp NOT NULL,
  last_updated_time timestamp NOT NULL,
  operation_user varchar(100) NOT NULL,
  operation_user_name varchar(100) NOT NULL,
  product_service_id bigint NOT NULL,
  PRIMARY KEY(id)
);

-- version 601 cs 
CREATE SEQUENCE parking_transaction_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;



  
-- version 603 cs   
CREATE TABLE IF NOT EXISTS hp_temp_charge_rule(
  id integer NOT NULL,
  tcrf_id integer NOT NULL UNIQUE,
  tcrf_passport_type_code integer NOT NULL,
  tcrf_charge_type_code integer NOT NULL,
  tcrf_wether_area_type smallint NOT NULL DEFAULT 0,
  tcrf_area_type smallint DEFAULT 2,
  tcrf_charge_type smallint NOT NULL, 
  tcrf_user_code varchar(100),
  tcrf_user_name varchar(100),
  tcrf_make_time timestamp,
  tcrf_reserved0 varchar(100),
  tcrf_reserved1 varchar(100),
  trcf_wether_pay smallint NOT NULL DEFAULT 0,
  trcf_pay numeric(30,2),
  trcf_wether_prepay smallint DEFAULT 0,
  trcf_prepay numeric(30,2),
  tcrf_wether_modify smallint DEFAULT 0,
  operation_user varchar(100),
  work_mode smallint NOT NULL DEFAULT 0,
  product_service_id bigint NOT NULL,
  PRIMARY KEY(id)
);


-- version 605 cs 
CREATE INDEX hp_temp_charge_rule_index_001 ON hp_temp_charge_rule (tcrf_passport_type_code,tcrf_charge_type_code);

-- version 606 cs 
CREATE UNIQUE INDEX hp_temp_charge_rule_index_002 ON hp_temp_charge_rule (tcrf_id);

-- version 607 cs 
CREATE SEQUENCE hp_temp_charge_rule_tcrf_id_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 608 cs
DROP TRIGGER IF EXISTS hp_temp_charge_rule_log_trigger ON hp_temp_charge_rule;

-- version 609 s 
CREATE TRIGGER hp_temp_charge_rule_log_trigger AFTER INSERT OR DELETE OR UPDATE ON hp_temp_charge_rule FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 610 cs   
CREATE TABLE IF NOT EXISTS hp_times_charge(
  id integer NOT NULL,
  tcf_id integer NOT NULL UNIQUE,
  tcf_temp_charge_rule_id integer NOT NULL,
  tcf_free_time smallint NOT NULL,
  tcf_money numeric(30,2) NOT NULL,
  tcf_user_code varchar(100),
  tcf_user_name varchar(100),
  tcf_make_time timestamp,
  tcf_reserved0 varchar(100),
  tcf_reserved1 varchar(100),
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  PRIMARY KEY(id)
);
 
-- version 612 cs 
CREATE INDEX hp_times_charge_index_001 ON hp_times_charge (tcf_temp_charge_rule_id);

-- version 613 cs 
CREATE UNIQUE INDEX hp_times_charge_index_002 ON hp_times_charge (tcf_id);

-- version 614 cs 
CREATE SEQUENCE hp_times_charge_tcf_id_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 615 cs
DROP TRIGGER IF EXISTS hp_times_charge_log_trigger ON hp_times_charge;

-- version 616 s 
CREATE TRIGGER hp_times_charge_log_trigger AFTER INSERT OR DELETE OR UPDATE ON hp_times_charge FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 617 cs  
CREATE TABLE IF NOT EXISTS hp_charge_strategy(
  id integer NOT NULL,
  csf_id integer NOT NULL UNIQUE,
  csf_temp_charge_type_id integer NOT NULL,
  csf_across_day smallint DEFAULT 0,
  csf_across_period smallint NOT NULL DEFAULT 0, 
  csf_wether_max_one_time smallint DEFAULT 0,
  csf_max_one_time numeric(30,2),
  csf_wether_add_time smallint NOT NULL DEFAULT 0, 
  csf_free_time_strategy smallint NOT NULL DEFAULT 1, 
  csf_user_code varchar(100),
  csf_user_name varchar(100),
  csf_make_time timestamp,
  csf_reserved0 varchar(100),
  csf_reserved1 varchar(100),
  csf_reserved2 varchar(100),
  csf_reserved3 varchar(100),
  csf_reserved4 varchar(100),
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id)
);


-- version 619 cs 
CREATE INDEX hp_charge_strategy_index_001 ON hp_charge_strategy (csf_temp_charge_type_id);

-- version 620 cs 
CREATE UNIQUE INDEX hp_charge_strategy_index_002 ON hp_charge_strategy (csf_id);

-- version 621 cs 
CREATE SEQUENCE hp_charge_strategy_csf_id_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 622 cs
DROP TRIGGER IF EXISTS hp_charge_strategy_log_trigger ON hp_charge_strategy;

-- version 623 s 
CREATE TRIGGER hp_charge_strategy_log_trigger AFTER INSERT OR DELETE OR UPDATE ON hp_charge_strategy FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 624 cs
CREATE TABLE IF NOT EXISTS hp_period_charge_strategy(
  id integer NOT NULL,
  pcsf_id integer NOT NULL UNIQUE,
  pcsf_charge_strategy_id integer NOT NULL,
  pcsf_wether_max_one_period smallint NOT NULL DEFAULT 0,
  pcsf_max_one_period numeric(30,2),
  pcsf_period_length smallint NOT NULL DEFAULT 24,
  pcsf_user_code varchar(100),
  pcsf_user_name varchar(100),
  pcsf_make_time timestamp,
  pcsf_reserved0 varchar(100),
  pcsf_reserved1 varchar(100),
  pcsf_reserved2 varchar(100),
  pcsf_reserved3 varchar(100),
  pcsf_reserved4 varchar(100),
  pcsf_date_type_code smallint DEFAULT 2,
  pcsf_date_type_name varchar(100),
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id)
);

-- version 626 cs 
CREATE INDEX hp_period_charge_strategy_index_001 ON hp_period_charge_strategy (pcsf_charge_strategy_id);

-- version 627 cs 
CREATE UNIQUE INDEX hp_period_charge_strategy_index_002 ON hp_period_charge_strategy (pcsf_id);

-- version 628 cs 
CREATE SEQUENCE hp_period_charge_strategy_pcsf_id_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 629 cs
DROP TRIGGER IF EXISTS hp_period_charge_strategy_log_trigger ON hp_period_charge_strategy;

-- version 630 s 
CREATE TRIGGER hp_period_charge_strategy_log_trigger AFTER INSERT OR DELETE OR UPDATE ON hp_period_charge_strategy FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 631 cs
CREATE TABLE IF NOT EXISTS hp_segment(
  id integer NOT NULL,  
  sf_id integer NOT NULL UNIQUE,
  sf_period_charge_strategy_id integer NOT NULL,
  sf_start_time time NOT NULL,
  sf_end_time time NOT NULL,
  sf_wether_max_one_segment smallint NOT NULL DEFAULT 0,
  sf_max_one_segment numeric(30,2),
  sf_free_in_validity smallint NOT NULL DEFAULT 0,
  sf_free_time smallint NOT NULL,
  sf_free_time_strategy smallint NOT NULL DEFAULT 0,
  sf_first_time smallint,
  sf_first_money numeric(30,2),
  sf_inter_time smallint,
  sf_inter_money numeric(30,2),
  sf_add_time smallint,
  sf_money_one_time numeric(30,2),
  sf_user_code varchar(100),
  sf_user_name varchar(100),
  sf_make_time timestamp,
  sf_reserved0 varchar(100),
  sf_reserved1 varchar(100),
  sf_reserved2 varchar(100),
  sf_reserved3 varchar(100),
  sf_reserved4 varchar(100),
  sf_segment_rule_scope smallint DEFAULT 0,
  sf_across_segment smallint DEFAULT 0,
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id)
);


-- version 633 cs 
CREATE INDEX hp_segment_index_001 ON hp_segment (sf_period_charge_strategy_id);

-- version 634 cs 
CREATE UNIQUE INDEX hp_segment_index_002 ON hp_segment (sf_id);

-- version 635 cs 
CREATE SEQUENCE hp_segment_sf_id_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 636 cs
DROP TRIGGER IF EXISTS hp_segment_log_trigger ON hp_segment;

-- version 637 s 
CREATE TRIGGER hp_segment_log_trigger AFTER INSERT OR DELETE OR UPDATE ON hp_segment FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 638 cs
CREATE TABLE IF NOT EXISTS hp_timeandmoney(
  id integer NOT NULL, 
  tf_id integer NOT NULL UNIQUE,
  tf_segment_id integer NOT NULL,
  tf_time smallint NOT NULL,
  tf_money numeric(30,2) NOT NULL,
  tf_user_code varchar(100),
  tf_user_name varchar(100),
  tf_make_time timestamp,
  tf_reserved0 varchar(100),
  tf_reserved1 varchar(100),
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id)
);


-- version 640 cs 
CREATE INDEX hp_timeandmoney_index_001 ON hp_timeandmoney (tf_segment_id);

-- version 641 cs 
CREATE UNIQUE INDEX hp_timeandmoney_index_002 ON hp_timeandmoney (tf_id);

-- version 642 cs 
CREATE SEQUENCE hp_timeandmoney_tf_id_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 643 cs
DROP TRIGGER IF EXISTS hp_timeandmoney_log_trigger ON hp_timeandmoney;

-- version 644 s 
CREATE TRIGGER hp_timeandmoney_log_trigger AFTER INSERT OR DELETE OR UPDATE ON hp_timeandmoney FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 645 cs   
CREATE TABLE IF NOT EXISTS hp_temprule_chanelarea(
  id integer NOT NULL,
  temp_charge_rule_id integer NOT NULL,
  id_value integer NOT NULL,
  id_type smallint NOT NULL,
  created_time timestamp NOT NULL,
  last_updated_time timestamp NOT NULL,
  operation_user varchar(100) NOT NULL,
  product_service_id bigint NOT NULL,
  PRIMARY KEY(id)
);


-- version 647 cs 
CREATE INDEX hp_temprule_chanelarea_index_001 ON hp_temprule_chanelarea (temp_charge_rule_id,id_value);

-- version 648 cs 
CREATE SEQUENCE hp_temprule_chanelarea_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 649 cs
DROP TRIGGER IF EXISTS hp_temprule_chanelarea_log_trigger ON hp_temprule_chanelarea;

-- version 650 s 
CREATE TRIGGER hp_temprule_chanelarea_log_trigger AFTER INSERT OR DELETE OR UPDATE ON hp_temprule_chanelarea FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 651 cs 
CREATE TABLE IF NOT EXISTS parking_pass_authorize_sync(
   id integer NOT NULL,
   authorize_type smallint NOT NULL,
   authorize_ref_id integer NOT NULL,
   date_range_id integer NOT NULL,
   area_channel_type smallint NOT NULL,
   pass_number_times integer NOT NULL DEFAULT 0,
   use_pass_times smallint NOT NULL DEFAULT 0,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,   
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);


-- version 653 cs 
CREATE INDEX parking_pass_authorize_sync_index_001 ON parking_pass_authorize_sync (authorize_ref_id,date_range_id);

-- version 654 cs 
CREATE SEQUENCE parking_pass_authorize_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 655 cs
DROP TRIGGER IF EXISTS parking_pass_authorize_sync_log_trigger ON parking_pass_authorize_sync;

-- version 656 s 
CREATE TRIGGER parking_pass_authorize_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_pass_authorize_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 657 cs 
CREATE TABLE IF NOT EXISTS parking_authorize_areachannel_sync(
   id integer NOT NULL,
   pass_authorize_id integer NOT NULL,
   pass_channel_id integer NOT NULL,
   pass_direction smallint NOT NULL,
   pass_area_id integer NOT NULL,
   remain_number_times integer NOT NULL DEFAULT 0,
   use_number_times smallint NOT NULL DEFAULT 0,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL, 
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);


-- version 659 cs 
CREATE INDEX parking_authorize_areachannel_sync_index_001 ON parking_authorize_areachannel_sync (pass_authorize_id);

-- version 660 cs 
CREATE SEQUENCE parking_authorize_areachannel_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 661 cs
DROP TRIGGER IF EXISTS parking_authorize_areachannel_sync_log_trigger ON parking_authorize_areachannel_sync;

-- version 662 s 
CREATE TRIGGER parking_authorize_areachannel_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_authorize_areachannel_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 663 cs 
CREATE INDEX parking_passport_sync_index_003 ON parking_passport_sync (register_plate);

-- version 664 cs 
CREATE TABLE IF NOT EXISTS parking_car_pass_record(
  id bigint NOT NULL,
  enter_record_id bigint,
  exit_record_id bigint,
  passport_id integer,
  passport_number varchar(100),
  medium_type smallint,
  passport_type_id integer,
  passport_type_name varchar(100),
  client_id integer,
  client_name varchar(100),
  parking_id integer,
  parking_name varchar(100),
  area_id integer,
  area_type smallint,
  area_level smallint,
  area_name varchar(100),
  pass_time timestamp,
  pass_plate varchar(50),
  pass_channel_id integer,
  pass_channel_name varchar(100),
  pass_direction smallint,
  enter_time timestamp,
  enter_channel_id integer,
  enter_channel_name varchar(100),
  enter_car_type_code integer,
  enter_pay numeric(30,2),
  enter_prepay numeric(30,2),
  enter_plate varchar(50),
  enter_plate_source smallint,
  enter_obu_plate varchar(50),
  enter_reg_plate varchar(50),
  enter_number_of_work_id bigint,
  enter_user_code varchar(100),
  enter_user_name varchar(100),
  enter_lan_state smallint,
  enter_computer_name varchar(100),
  enter_pass_value smallint,
  enter_channel_managed_mode smallint,
  enter_remark1 varchar(50),
  enter_remark2 varchar(50),
  enter_remark3 varchar(100),
  enter_remark4 varchar(200),
  enter_remark5 varchar(300),
  exit_time timestamp,
  exit_channel_id integer,
  exit_channel_name varchar(100),
  exit_car_type_code integer,
  exit_plate varchar(50),
  exit_plate_source smallint,
  exit_obu_plate varchar(50),
  exit_reg_plate varchar(50),
  exit_number_of_work_id bigint,
  exit_user_code varchar(100),
  exit_user_name varchar(100),
  exit_lan_state smallint,
  exit_computer_name varchar(100),
  exit_pass_value smallint,
  exit_channel_managed_mode smallint,
  exit_remark1 varchar(50),
  exit_remark2 varchar(50),
  exit_remark3 varchar(100),
  exit_remark4 varchar(200),
  exit_remark5 varchar(300),
  exit_parking_time_length integer,
  exit_fee_time_length integer,
  exit_should_charge numeric(30,2),
  exit_practice_charge numeric(30,2),
  certificate_capture smallint,
  card_charge numeric(30,2),
  charge_method smallint,
  deduct_money numeric(30,2), 
  cash numeric(30,2),
  cost_times integer,
  discount_money numeric(30,2), 
  and_pay numeric(30,2),
  fee_comment varchar(1000),
  created_time timestamp,
  last_updated_time timestamp,
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  parking_space_type smallint,
  PRIMARY KEY (id)
);

-- version 665 cs 
CREATE SEQUENCE parking_car_pass_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 666 cs 
CREATE INDEX parking_car_pass_record_index_001 ON parking_car_pass_record (passport_number,area_id,pass_time);

-- version 667 cs 
CREATE TABLE IF NOT EXISTS parking_dispatch_record(
    id bigint NOT NULL,
    record_table_name varchar(100) NOT NULL,
    record_table_id_name varchar(100) NOT NULL,
    record_table_id_value bigint NOT NULL,
    dispatch_computer_name varchar(100) NOT NULL,
    dispatch_host varchar(100),
    dispatch_state smallint NOT NULL DEFAULT 0,
    operation char(1) NOT NULL,
    transaction_id bigint NOT NULL,
    created_time timestamp,
    product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);

-- version 668 cs 
CREATE SEQUENCE parking_dispatch_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;


-- version 669 cs 
CREATE TABLE IF NOT EXISTS parking_number_of_work(
  id bigint NOT NULL,
  start_time timestamp,
  end_time timestamp,
  login_user_code varchar(100),
  login_user_name varchar(100),
  computer_name varchar(100),
  state smallint,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 670 cs 
CREATE SEQUENCE parking_number_of_work_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 671 cs 
CREATE INDEX parking_number_of_work_index_001 ON parking_number_of_work (computer_name,start_time);

-- version 672 cs 
CREATE TABLE IF NOT EXISTS parking_capture(
  id bigint NOT NULL,
  pass_record_id bigint,
  pass_record_type smallint,
  capture_time timestamp,
  picture_use smallint,
  picture_path varchar(200),
  trigger_method smallint,
  user_code varchar(100),
  user_name varchar(100),
  pass_area_id integer,
  pass_channel_id integer,
  pass_direction smallint,
  pass_time timestamp,
  computer_name varchar(100),
  camera_id integer,
  capture_success smallint,
  parking_id integer,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 673 cs 
CREATE SEQUENCE parking_capture_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 674 cs 
CREATE INDEX parking_capture_index_001 ON parking_capture (pass_record_id,pass_time);

-- version 675 cs 
CREATE TABLE IF NOT EXISTS parking_regplate_record(
   id bigint NOT NULL,
   pass_time timestamp,
   pass_area_id integer,
   pass_channel_id integer,
   pass_direction smallint,
   reg_plate_number varchar(50),
   computer_name varchar(100),
   picture_path varchar(200),
   number_of_work_id bigint,
   parking_id integer,
   camera_id integer,
   recognition_id integer,
   user_code varchar(100),
   user_name varchar(100),
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id) 
);

-- version 676 cs 
CREATE SEQUENCE parking_regplate_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 677 cs 
CREATE INDEX parking_regplate_record_index_001 ON parking_regplate_record (reg_plate_number,pass_time);

-- version 678 cs 
CREATE TABLE IF NOT EXISTS parking_deduct_record(
  id bigint NOT NULL,
  pass_record_id bigint,
  deduct_account_type smallint,
  passport_or_account_id integer,
  client_id integer,
  computer_name varchar(100),
  number_of_work_id bigint,
  user_code varchar(100),
  user_name varchar(100),
  deduct_money numeric(30,2),
  deduct_number_times smallint,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 679 cs 
CREATE SEQUENCE parking_deduct_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 680 cs 
CREATE INDEX parking_deduct_record_index_001 ON parking_deduct_record (pass_record_id,passport_or_account_id);

-- version 681 cs 
CREATE TABLE IF NOT EXISTS parking_special_pass_record(
   id bigint NOT NULL,
   pass_time timestamp,
   pass_area_id integer,
   pass_channel_id integer,
   pass_direction smallint,
   reg_plate_number varchar(50),
   computer_name varchar(100),
   pass_reason_code integer,
   pass_reason varchar(300),
   remark varchar(500),
   number_of_work_id bigint,
   parking_id integer,
   user_code varchar(100),
   user_name varchar(100),
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id) 
);

-- version 682 cs 
CREATE SEQUENCE parking_special_pass_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 683 cs 
CREATE INDEX parking_special_pass_record_index_001 ON parking_special_pass_record (pass_time,pass_channel_id);

-- version 684 cs 
CREATE TABLE IF NOT EXISTS  parking_discount_record(
  id bigint NOT NULL,
  pass_record_id bigint,
  proj_code varchar(100),
  proj_name varchar(100),
  discount_method smallint,
  discount_time integer,
  discount_money numeric(30,2),
  discount_ratio numeric(30,2),
  free_expiration_time timestamp,
  discount_type smallint,
  discount_client_id integer,
  discount_account_id integer,
  discount_client_name varchar(100),
  pay_type smallint,
  pay_money numeric(30,2),
  number_of_work_id bigint,
  parking_id integer,
  user_code varchar(100),
  user_name varchar(100),
  make_time timestamp,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 685 cs 
CREATE SEQUENCE parking_discount_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 686 cs 
CREATE INDEX parking_discount_record_index_001 ON parking_discount_record (pass_record_id);

-- version 687 cs 
CREATE TABLE IF NOT EXISTS parking_period_charge_record(
  id bigint NOT NULL,
  main_id bigint,
  new_main_id bigint,
  enter_time timestamp,
  exit_time timestamp,
  money numeric(30,2),
  charge_time_length integer,
  car_plate varchar(50),
  number_of_work_id bigint,
  user_code varchar(100),
  user_name varchar(100),
  make_time timestamp,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 688 cs 
CREATE SEQUENCE parking_period_charge_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 689 cs 
CREATE INDEX parking_period_charge_record_index_001 ON parking_period_charge_record (make_time);

-- version 690 cs 
CREATE TABLE IF NOT EXISTS parking_period_charge_main(
  id bigint NOT NULL,
  plate_number varchar(50),
  start_time timestamp,
  yet_charge numeric(30,2),
  time_length integer,
  end_time timestamp,
  parking_id integer,
  number_of_work_id bigint,
  user_code varchar(100),
  user_name varchar(100),
  make_time timestamp,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 691 cs 
CREATE SEQUENCE parking_period_charge_main_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 692 cs 
CREATE INDEX parking_period_charge_main_index_001 ON parking_period_charge_main (plate_number,start_time);

-- version 693 cs 
CREATE TABLE IF NOT EXISTS parking_period_charge_detail(
  id bigint NOT NULL,
  main_id bigint,
  enter_time timestamp,
  exit_time timestamp,
  money numeric(30,2),
  charge_time_length integer,
  car_plate varchar(50),
  number_of_work_id bigint,
  user_code varchar(100),
  user_name varchar(100),
  make_time timestamp,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 694 cs 
CREATE INDEX parking_period_charge_detail_index_001 ON parking_period_charge_detail (main_id);

-- version 695 cs 
CREATE TABLE IF NOT EXISTS parking_charge_record(
  id bigint NOT NULL,
  pass_record_id bigint,
  subject_one smallint,
  subject_two smallint,
  direction smallint,
  method smallint, 
  money numeric(30,2),
  client_id integer,
  client_name varchar(100),
  account_id integer,
  deduct_type smallint,
  passport_id integer,
  passport_number varchar(100),
  medium_type smallint,
  plate_number varchar(100),
  pass_time timestamp,
  pass_area_id integer,
  pass_channel_id integer,
  pass_direction smallint,
  computer_name varchar(100),
  data_computer_name varchar(100),
  number_of_work_id bigint,
  parking_id integer,
  user_code varchar(100),
  user_name varchar(100),
  make_time timestamp,
  product_service_id bigint NOT NULL,
  PRIMARY KEY (id) 
);

-- version 696 cs 
CREATE SEQUENCE parking_charge_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 697 cs 
CREATE INDEX parking_charge_record_index_001 ON parking_charge_record (make_time,pass_channel_id);


-- version 699 cs 
CREATE TABLE IF NOT EXISTS parking_car_pass_record_history(
  id bigint NOT NULL,
  enter_record_id bigint,
  exit_record_id bigint,
  passport_id integer,
  passport_number varchar(100),
  medium_type smallint,
  passport_type_id integer,
  passport_type_name varchar(100),
  client_id integer,
  client_name varchar(100),
  parking_id integer,
  parking_name varchar(100),
  area_id integer,
  area_type smallint,
  area_level smallint,
  area_name varchar(100),
  pass_time timestamp,
  pass_plate varchar(50),
  pass_channel_id integer,
  pass_channel_name varchar(100),
  pass_direction smallint,
  enter_time timestamp,
  enter_channel_id integer,
  enter_channel_name varchar(100),
  enter_car_type_code integer,
  enter_pay numeric(30,2),
  enter_prepay numeric(30,2),
  enter_plate varchar(50),
  enter_plate_source smallint,
  enter_obu_plate varchar(50),
  enter_reg_plate varchar(50),
  enter_number_of_work_id bigint,
  enter_user_code varchar(100),
  enter_user_name varchar(100),
  enter_lan_state smallint,
  enter_computer_name varchar(100),
  enter_pass_value smallint,
  enter_channel_managed_mode smallint,
  enter_remark1 varchar(50),
  enter_remark2 varchar(50),
  enter_remark3 varchar(100),
  enter_remark4 varchar(200),
  enter_remark5 varchar(300),
  exit_time timestamp,
  exit_channel_id integer,
  exit_channel_name varchar(100),
  exit_car_type_code integer,
  exit_plate varchar(50),
  exit_plate_source smallint,
  exit_obu_plate varchar(50),
  exit_reg_plate varchar(50),
  exit_number_of_work_id bigint,
  exit_user_code varchar(100),
  exit_user_name varchar(100),
  exit_lan_state smallint,
  exit_computer_name varchar(100),
  exit_pass_value smallint,
  exit_channel_managed_mode smallint,
  exit_remark1 varchar(50),
  exit_remark2 varchar(50),
  exit_remark3 varchar(100),
  exit_remark4 varchar(200),
  exit_remark5 varchar(300),
  exit_parking_time_length integer,
  exit_fee_time_length integer,
  exit_should_charge numeric(30,2),
  exit_practice_charge numeric(30,2),
  certificate_capture smallint,
  card_charge numeric(30,2),
  charge_method smallint,
  deduct_money numeric(30,2), 
  cash numeric(30,2),
  cost_times integer,
  discount_money numeric(30,2), 
  and_pay numeric(30,2),
  fee_comment varchar(1000),
  created_time timestamp,
  last_updated_time timestamp,
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  parking_space_type smallint,
  PRIMARY KEY (id)
);

-- version 700 cs 
CREATE TABLE IF NOT EXISTS parking_car_pass_enter_record(
  id bigint NOT NULL,
  enter_record_id bigint,
  exit_record_id bigint,
  passport_id integer,
  passport_number varchar(100),
  medium_type smallint,
  passport_type_id integer,
  passport_type_name varchar(100),
  client_id integer,
  client_name varchar(100),
  parking_id integer,
  parking_name varchar(100),
  area_id integer,
  area_type smallint,
  area_level smallint,
  area_name varchar(100),
  pass_time timestamp,
  pass_plate varchar(50),
  pass_channel_id integer,
  pass_channel_name varchar(100),
  pass_direction smallint,
  enter_time timestamp,
  enter_channel_id integer,
  enter_channel_name varchar(100),
  enter_car_type_code integer,
  enter_pay numeric(30,2),
  enter_prepay numeric(30,2),
  enter_plate varchar(50),
  enter_plate_source smallint,
  enter_obu_plate varchar(50),
  enter_reg_plate varchar(50),
  enter_number_of_work_id bigint,
  enter_user_code varchar(100),
  enter_user_name varchar(100),
  enter_lan_state smallint,
  enter_computer_name varchar(100),
  enter_pass_value smallint,
  enter_channel_managed_mode smallint,
  enter_remark1 varchar(50),
  enter_remark2 varchar(50),
  enter_remark3 varchar(100),
  enter_remark4 varchar(200),
  enter_remark5 varchar(300),
  exit_time timestamp,
  exit_channel_id integer,
  exit_channel_name varchar(100),
  exit_car_type_code integer,
  exit_plate varchar(50),
  exit_plate_source smallint,
  exit_obu_plate varchar(50),
  exit_reg_plate varchar(50),
  exit_number_of_work_id bigint,
  exit_user_code varchar(100),
  exit_user_name varchar(100),
  exit_lan_state smallint,
  exit_computer_name varchar(100),
  exit_pass_value smallint,
  exit_channel_managed_mode smallint,
  exit_remark1 varchar(50),
  exit_remark2 varchar(50),
  exit_remark3 varchar(100),
  exit_remark4 varchar(200),
  exit_remark5 varchar(300),
  exit_parking_time_length integer,
  exit_fee_time_length integer,
  exit_should_charge numeric(30,2),
  exit_practice_charge numeric(30,2),
  certificate_capture smallint,
  card_charge numeric(30,2),
  charge_method smallint,
  deduct_money numeric(30,2), 
  cash numeric(30,2),
  cost_times integer,
  discount_money numeric(30,2), 
  and_pay numeric(30,2),
  fee_comment varchar(1000),
  created_time timestamp,
  last_updated_time timestamp,
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  parking_space_type smallint,
  PRIMARY KEY (id)
);

-- version 701 cs 
CREATE INDEX parking_car_pass_enter_record_index_001 ON parking_car_pass_enter_record (passport_number);

-- version 702 cs 
CREATE TABLE IF NOT EXISTS parking_business_strategy_sync(
    id integer NOT NULL,
    parent_id integer NOT NULL DEFAULT 0,
    strategy_name varchar(100) NOT NULL,
    name_description varchar(100) NULL,
    strategy_value varchar(255) NOT NULL,
    value_description varchar(100) NULL,
    strategy_type smallint NOT NULL,
    parking_id integer NOT NULL,
    channel_id integer NULL,
    passport_type_id integer NULL,
    car_type_code integer NULL,
    sysem_created smallint NOT NULL DEFAULT 0,
    created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 703 cs 
CREATE SEQUENCE parking_business_strategy_sync_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 704 cs 
CREATE INDEX parking_business_strategy_sync_index_001 ON parking_business_strategy_sync (parking_id,strategy_type,strategy_name);

-- version 705 cs
DROP TRIGGER IF EXISTS parking_business_strategy_sync_log_trigger ON parking_business_strategy_sync;

-- version 706 s 
CREATE TRIGGER parking_business_strategy_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_business_strategy_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 707 cs 
CREATE INDEX parking_dispatch_record_index_001 ON parking_dispatch_record (dispatch_computer_name,transaction_id);

-- version 708 cs 
CREATE INDEX parking_car_pass_record_history_index_001 ON parking_car_pass_record_history (passport_number,pass_time DESC);

-- version 709 cs 
CREATE TABLE IF NOT EXISTS parking_recovery_card_log(
    id bigint NOT NULL,
    take_card_time timestamp NOT NULL,
    passport_id integer,
    passport_number varchar(100),
    passport_type_id integer,
    passport_type_name varchar(100),
    parking_id integer NOT NULL,
    parking_name varchar(100),
    channel_id integer NULL,
    channel_name varchar(100),
    area_id integer NOT NULL,
    area_name varchar(100),
    recovery_type smallint,
    recovery_reason varchar(300),
    take_card_plate varchar(50),
	operation_user varchar(100),
	card_sender_id integer,
	card_sender_name varchar(100),
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 710 cs 
CREATE INDEX parking_recovery_card_log_index_001 ON parking_recovery_card_log (take_card_time);

-- version 711 cs 
CREATE SEQUENCE parking_recovery_card_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 712 cs 
CREATE INDEX parking_voice_display_sync_index_002 ON parking_voice_display_sync (use_code);

-- version 713 cs 
CREATE TABLE IF NOT EXISTS parking_passport_sync_backup(
    id integer NOT NULL,
    client_id integer NULL,
	passport_number varchar(100) NOT NULL,
	medium_type smallint NOT NULL,
	pass_type_id integer NOT NULL,
	car_type_id integer NOT NULL,
	surface_number varchar(100) NULL,
	register_plate varchar(50) NULL,
	parking_space_type smallint NULL, 
	parking_space_no varchar(100) NULL,
	deduct_way smallint NOT NULL DEFAULT 0,
	account_id integer NULL,
	car_pic varchar(200) NULL,
	car_color_type integer NULL,
	ic_sector varchar(50) NULL,
	ic_key varchar(50) NULL,
	ic_as_id smallint NOT NULL DEFAULT 0,
	passport_state smallint NOT NULL DEFAULT 0,
	deadline timestamp NULL,
    number_times integer NOT NULL DEFAULT 0,
    balance decimal(30,2) NOT NULL DEFAULT 0,
    cash_pledge decimal(30,2) NOT NULL DEFAULT 0,
    arrears_limit decimal(30,2) NOT NULL DEFAULT 0,
    times_limit integer NOT NULL DEFAULT 0,
    remark varchar(300),
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	start_date timestamp NULL,
	new_passport_number varchar(100) NULL,
	new_medium_type smallint NULL,
	new_register_plate varchar(50) NULL
);

-- version 714 cs 
CREATE TABLE IF NOT EXISTS parking_push_message(
    id bigint NOT NULL,
    push_message varchar(3000) NOT NULL,
    push_host varchar(100),
    push_computer_name varchar(100),
    created_time timestamp,
    product_service_id bigint NOT NULL,
    operation_user varchar(100),
    PRIMARY KEY (id)
);

-- version 715 cs
CREATE SEQUENCE parking_push_message_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 716 cs
CREATE INDEX parking_push_message_index_001 ON parking_push_message (push_computer_name,product_service_id);

-- version 717 cs 
CREATE TABLE IF NOT EXISTS parking_date_type_sync(
   id integer NOT NULL,
   parking_date date NOT NULL,
   date_type smallint NOT NULL,
   description varchar(300) NULL,
   sysem_created smallint NOT NULL DEFAULT 0,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 718 cs
CREATE INDEX parking_date_type_sync_index_001 ON parking_date_type_sync (parking_date,date_type);

-- version 719 cs 
CREATE SEQUENCE parking_date_type_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 720 cs
DROP TRIGGER IF EXISTS parking_date_type_sync_log_trigger ON parking_date_type_sync;

-- version 721 s 
CREATE TRIGGER parking_date_type_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_date_type_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 722 cs 
CREATE TABLE IF NOT EXISTS parking_discount_sync(
   id integer NOT NULL,
   proj_code varchar(100) NOT NULL,
   proj_name varchar(100),
   discount_method smallint,
   discount_time integer,
   discount_money numeric(30,2),
   discount_ratio numeric(30,2),
   discount_type smallint,
   pay_type smallint,
   discount_client_id integer,
   discount_account_id integer,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 723 cs
CREATE INDEX parking_discount_sync_index_001 ON parking_discount_sync (discount_type,proj_code);

-- version 724 cs 
CREATE SEQUENCE parking_discount_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 725 cs
DROP TRIGGER IF EXISTS parking_discount_sync_log_trigger ON parking_discount_sync;

-- version 726 s 
CREATE TRIGGER parking_discount_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_discount_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 727 cs 
CREATE TABLE IF NOT EXISTS parking_write_card_cancel_record(
   id bigint NOT NULL,
   card_number varchar(100) NOT NULL,
   pass_area_id integer NOT NULL,
   pass_channel_id integer NOT NULL,
   pass_direction smallint NOT NULL,
   pass_enter_time timestamp NOT NULL,
   card_old_info varchar(500) NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 728 cs 
CREATE SEQUENCE parking_write_card_cancel_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 729 cs
CREATE INDEX parking_write_card_cancel_record_index_001 ON parking_write_card_cancel_record (card_number,pass_enter_time);

-- version 730 cs 
CREATE TABLE IF NOT EXISTS parking_present_period_charge(
   id bigint NOT NULL,
   plate_number varchar(100) NOT NULL,
   area_id integer NOT NULL,
   pass_time timestamp NOT NULL,
   charged numeric(30,2) NOT NULL,
   use_type smallint  NOT NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 731 cs 
CREATE SEQUENCE parking_present_period_charge_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 732 cs
CREATE INDEX parking_present_period_charge_index_001 ON parking_present_period_charge (plate_number,area_id,pass_time);

-- version 733 cs 
CREATE TABLE IF NOT EXISTS parking_uri_sequence(
   uri varchar(100) NOT NULL,
   seq bigint NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY(uri,product_service_id)
);

-- version 734 cs 
CREATE SEQUENCE parking_uri_sequence_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 735 cs 
ALTER TABLE parking_charge_record ADD COLUMN car_type_id integer;

-- version 736 cs 
ALTER TABLE parking_charge_record ADD COLUMN car_type_name varchar(100);

-- version 737 cs 
ALTER TABLE parking_charge_record ADD COLUMN passport_type_id integer;

-- version 738 cs 
ALTER TABLE parking_charge_record ADD COLUMN passport_type_name varchar(100);

-- version 739 cs 
CREATE INDEX parking_car_pass_record_history_index_002 ON parking_car_pass_record_history (pass_time,pass_plate);

-- version 740 cs 
ALTER TABLE parking_special_pass_record ADD COLUMN pass_channel_name varchar(100);

-- version 741 cs 
ALTER TABLE parking_special_pass_record ADD COLUMN pass_area_name varchar(100);

-- version 742 cs 
ALTER TABLE parking_special_pass_record ADD COLUMN reg_plate_source smallint;

-- version 743 cs 
CREATE TABLE IF NOT EXISTS parking_illegal_pass_record(
    id bigint NOT NULL,
    pass_time timestamp NOT NULL,
    pass_plate varchar(50),
    parking_id integer NOT NULL,
    parking_name varchar(100),
    channel_id integer NULL,
    channel_name varchar(100),
    area_id integer NOT NULL,
    area_name varchar(100),
    pass_type smallint,
    description varchar(300),
    computer_name varchar(100),
	operation_user varchar(100),
	operation_user_name varchar(100),
	product_service_id bigint NOT NULL,
	PRIMARY KEY (id)
);

-- version 744 cs 
CREATE INDEX parking_illegal_pass_record_index_001 ON parking_illegal_pass_record (pass_time,channel_id);

-- version 745 cs 
CREATE SEQUENCE parking_illegal_pass_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 746 cs 
CREATE TABLE IF NOT EXISTS parking_sync_data_table(
	table_name varchar(64) NOT NULL,
	description varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
	default_order smallint NOT NULL DEFAULT 0,
	table_pk_name varchar(32) NOT NULL DEFAULT 'id',
	latest_sync_pk_value bigint NOT NULL DEFAULT 0,
    sync_state smallint NOT NULL DEFAULT 0,
    sync_start_time timestamp,
    sync_end_time timestamp,
	attr1 varchar(50),
	attr2 varchar(50),
	attr3 varchar(100),
	attr4 varchar(100),
	attr5 varchar(200),
	attr6 varchar(200),
	PRIMARY KEY(table_name)
);

-- version 747 cs 
ALTER TABLE parking_number_of_work ADD COLUMN parking_id integer;

-- version 748 cs 
ALTER TABLE parking_write_card_cancel_record ADD COLUMN parking_id integer;

-- version 749 cs 
ALTER TABLE parking_present_period_charge ADD COLUMN parking_id integer;

-- version 750 cs 
CREATE INDEX parking_capture_index_002 ON parking_capture (picture_path);

-- version 751 cs 
ALTER TABLE parking_regplate_record ADD COLUMN pass_area_name varchar(100);

-- version 752 cs 
ALTER TABLE parking_regplate_record ADD COLUMN pass_channel_name varchar(100);

-- version 753 cs 
ALTER TABLE parking_regplate_record ADD COLUMN camera_name varchar(100);

-- version 754 cs 
CREATE INDEX parking_transaction_record_index_001 ON parking_transaction_record (transaction_time,transaction_type,transaction_subject);

-- version 755 cs 
ALTER TABLE parking_capture ADD COLUMN plate_pic_path varchar(200);

-- version 756 cs
ALTER TABLE parking_regplate_record ADD COLUMN plate_pic_path varchar(200);

-- version 757 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN enter_plate_color varchar(32);

-- version 758 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN exit_plate_color varchar(32);

-- version 759 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN enter_plate_color varchar(32);

-- version 760 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN exit_plate_color varchar(32);

-- version 761 cs
ALTER TABLE parking_car_pass_record ADD COLUMN enter_plate_color varchar(32);

-- version 762 cs
ALTER TABLE parking_car_pass_record ADD COLUMN exit_plate_color varchar(32);

-- version 763 cs
CREATE TABLE IF NOT EXISTS parking_fee_sef_record(
   id bigint NOT NULL,
   paid_amount decimal(30,2) NOT NULL,
   paid_type smallint NOT NULL,
   paid_description varchar(300) NULL,
   paid_time timestamp NOT NULL,
   leave_time timestamp NULL,
   passport_number varchar(100) NOT NULL,
   medium_type smallint NOT NULL,
   enter_time timestamp NOT NULL,
   plate_number varchar(50),
   parking_id integer,
   area_id integer,
   enter_record_id bigint,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 764 cs 
CREATE INDEX parking_fee_sef_record_index_001 ON parking_fee_sef_record(passport_number,enter_time);

-- version 765 cs 
CREATE SEQUENCE parking_fee_sef_record_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 766 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN soruce_type integer;

-- version 767 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN operation_user_name varchar(100);

-- version 768 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN computer_name varchar(100);

-- version 769 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN car_type_id integer;

-- version 770 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN car_type_name varchar(100);

-- version 771 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN passport_type_id integer;

-- version 772 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN passport_type_name varchar(100);

-- version 773 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN passport_id integer;

-- version 774 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN enter_channel_id integer;

-- version 775 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN enter_chanel_name varchar(100);

-- version 776 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN client_id integer;

-- version 777 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN client_name varchar(100);

-- version 778 cs
ALTER TABLE parking_charge_record ADD COLUMN charge_de smallint;

-- version 779 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN enter_car_type_name varchar(100);

-- version 780 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN exit_car_type_name varchar(100);

-- version 781 cs
ALTER TABLE parking_car_pass_record ADD COLUMN enter_car_type_name varchar(100);

-- version 782 cs
ALTER TABLE parking_car_pass_record ADD COLUMN exit_car_type_name varchar(100);

-- version 783 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN enter_car_type_name varchar(100);

-- version 784 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN exit_car_type_name varchar(100);

-- version 785 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN should_charge decimal(30,2);

-- version 786 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN discount_money decimal(30,2);

-- version 787 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN charge_time_length integer;

-- version 788 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN enter_pay decimal(30,2);

-- version 789 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN enter_pre_pay decimal(30,2);

-- version 790 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN card_fee decimal(30,2);

-- version 791 cs
CREATE TABLE IF NOT EXISTS parking_visitor_authorization(
  id bigint NOT NULL,  
  passport_number varchar(100),
  medium_type smallint,
  plate_number varchar(50),
  register_type smallint,
  begin_time timestamp,
  end_time timestamp,
  exit_time timestamp,
  visitor_times integer,
  remark varchar(300),
  created_time timestamp,
  operation_user varchar(100),
  operation_user_name varchar(100),
  product_service_id bigint NOT NULL,
  area_id integer,
  area_name varchar(100),
  visitor_name varchar(100),
  PRIMARY KEY (id)
);

-- version 792 cs 
CREATE INDEX parking_visitor_authorization_001 ON parking_visitor_authorization (passport_number,begin_time,end_time);

-- version 793 cs 
CREATE SEQUENCE parking_visitor_authorization_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 794 cs
DROP TRIGGER IF EXISTS parking_visitor_authorization_log_trigger ON parking_visitor_authorization;

-- version 795 s 
CREATE TRIGGER parking_visitor_authorization_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_visitor_authorization FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 796 cs 
CREATE INDEX parking_visitor_authorization_002 ON parking_visitor_authorization (REVERSE(plate_number));

-- version 797 cs 
ALTER TABLE parking_fee_sef_record ADD COLUMN charge_record_id bigint;

-- version 798 cs 
CREATE TABLE parking_fee_sef_record_messge(
  id bigint NOT NULL,
  paid_amount decimal(30,2) NOT NULL,
  paid_type smallint NOT NULL,
  paid_description varchar(300),
  paid_time timestamp NOT NULL,
  leave_time timestamp,
  passport_number varchar(100) NOT NULL,
  medium_type smallint NOT NULL,
  enter_time timestamp NOT NULL,
  plate_number varchar(50),
  parking_id integer,
  area_id integer,
  enter_record_id bigint,
  created_time timestamp NOT NULL,
  last_updated_time timestamp NOT NULL,
  operation_user varchar(100) NOT NULL,
  product_service_id bigint NOT NULL,
  soruce_type integer,
  operation_user_name varchar(100),
  computer_name varchar(100),
  car_type_id integer,
  car_type_name varchar(100),
  passport_type_id integer,
  passport_type_name varchar(100),
  passport_id integer,
  enter_channel_id integer,
  enter_chanel_name varchar(100),
  client_id integer,
  client_name varchar(100),
  should_charge decimal(30,2),
  discount_money decimal(30,2),
  charge_time_length integer,
  enter_pay decimal(30,2),
  enter_pre_pay decimal(30,2),
  card_fee decimal(30,2),
  charge_record_id bigint,
  PRIMARY KEY (id)
);

-- version 799 cs
CREATE INDEX parking_fee_sef_record_messge_index_001 ON parking_fee_sef_record_messge(passport_number,enter_time);

-- version 800 cs
ALTER TABLE parking_areas_sync ADD COLUMN truck_quantities integer;

-- version 801 cs 
CREATE TABLE IF NOT EXISTS parking_blacklist_sync(
   id integer NOT NULL,
   plate_number varchar(100) NOT NULL,
   voice_info varchar(100) NULL,
   display_info varchar(100) NULL,
   remark varchar(500) NULL,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   operation_user_name varchar(100),
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 802 cs 
CREATE INDEX parking_blacklist_sync_index_001 ON parking_blacklist_sync (plate_number);

-- version 803 cs
DROP TRIGGER IF EXISTS parking_blacklist_sync_log_trigger ON parking_blacklist_sync;

-- version 804 s
CREATE TRIGGER parking_blacklist_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_blacklist_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 805 cs 
CREATE SEQUENCE parking_blacklist_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 806 cs
ALTER TABLE parking_car_pass_record ADD COLUMN app_paid_description varchar(300);

-- version 807 cs
ALTER TABLE parking_car_pass_record ADD COLUMN app_paid_time timestamp;

-- version 808 cs
ALTER TABLE parking_car_pass_record ADD COLUMN app_paid_type smallint;

-- version 809 cs
ALTER TABLE parking_car_pass_record ADD COLUMN app_paid_amount decimal(30,2);

-- version 810 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN app_paid_description varchar(300);

-- version 811 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN app_paid_time timestamp;

-- version 812 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN app_paid_type smallint;

-- version 813 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN app_paid_amount decimal(30,2);

-- version 814 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN app_paid_description varchar(300);

-- version 815 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN app_paid_time timestamp;

-- version 816 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN app_paid_type smallint;

-- version 817 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN app_paid_amount decimal(30,2);

-- version 818 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN passed_times integer;

-- version 819 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN visitor_phone varchar(100);

-- version 820 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN visitor_company varchar(100);

-- version 821 cs 
CREATE INDEX parking_visitor_authorization_003 ON parking_visitor_authorization (created_time);

-- version 822 cs 
DROP INDEX parking_visitor_authorization_001;

-- version 823 cs 
CREATE INDEX parking_visitor_authorization_001 ON parking_visitor_authorization (passport_number);

-- version 824 cs 
CREATE TABLE IF NOT EXISTS parking_local_uploadData(
   id bigint NOT NULL,
   json_msg varchar(3000) NOT NULL,
   created_time timestamp NOT NULL,
   product_service_id bigint NOT NULL,
   action_name varchar(50) NOT NULL,
   method_name varchar(50) NOT NULL,
   PRIMARY KEY (id)
);

-- version 825 cs 
CREATE SEQUENCE parking_local_uploadData_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 826 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN passport_type_id integer;

-- version 827 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN passport_type_name varchar(100);

-- version 828 cs
CREATE INDEX parking_car_pass_enter_record_index_002 ON parking_car_pass_enter_record (enter_time);

-- version 829 cs
CREATE TABLE IF NOT EXISTS parking_area_attr_sync(
	id integer NOT NULL,
    temp_space_taked integer NOT NULL,
    fixed_space_taked integer NOT NULL,
    special_space_taked integer NOT NULL,
    truck_space_taked integer NOT NULL,
	parking_id integer NULL,
	created_time timestamp NOT NULL,
	created_user varchar(100) NOT NULL,
	last_updated_time timestamp NOT NULL,
	operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);

-- version 830 cs
DROP TRIGGER IF EXISTS parking_area_attr_sync_log_trigger ON parking_area_attr_sync;

-- version 831 s
CREATE TRIGGER parking_area_attr_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_area_attr_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 832 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN passport_balance decimal(30,2);

-- version 833 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN passport_number_times integer;

-- version 834 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN deadline timestamp;

-- version 835 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN account_balance decimal(30,2);

-- version 836 cs
ALTER TABLE parking_car_pass_record ADD COLUMN passport_balance decimal(30,2);

-- version 837 cs
ALTER TABLE parking_car_pass_record ADD COLUMN passport_number_times integer;

-- version 838 cs
ALTER TABLE parking_car_pass_record ADD COLUMN deadline timestamp;

-- version 839 cs
ALTER TABLE parking_car_pass_record ADD COLUMN account_balance decimal(30,2);

-- version 840 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN passport_balance decimal(30,2);

-- version 841 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN passport_number_times integer;

-- version 842 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN deadline timestamp;

-- version 843 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN account_balance decimal(30,2);

-- version 844 cs
CREATE TABLE IF NOT EXISTS parking_fee_report(
	id bigint NOT NULL,
    parking_id integer,
    year smallint,
    quarter smallint,
    month smallint,
    day smallint,
	report_date date,
	operation_user varchar(100),
	operation_user_name varchar(100),
	passport_type_id integer,
	passport_type_name varchar(100),
	pay_app varchar(100),
	pay_app0 varchar(100),
	pay_type smallint,
	pay_subject smallint,
	pay_method smallint,
	pay_money decimal(30,2),
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	product_service_id bigint NOT NULL,
	report_type smallint NOT NULL,
	car_type_id integer,
	car_type_name varchar(100),
	computer_name varchar(100),
    PRIMARY KEY (id)
);

-- version 845 cs 
CREATE INDEX parking_fee_report_index_001 ON parking_fee_report (report_date);

-- version 846 cs 
CREATE SEQUENCE parking_fee_report_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 847 cs
CREATE TABLE IF NOT EXISTS parking_car_flow_report(
	id bigint NOT NULL,
    parking_id integer,
    year smallint,
    month smallint,
    day smallint,
    hour smallint,
	report_date timestamp,
	channel_id integer,
	channel_name varchar(100),
	flow_count integer,
	operation_user varchar(100),
	created_time timestamp NOT NULL,
	last_updated_time timestamp NOT NULL,
	product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);

-- version 848 cs 
CREATE INDEX parking_car_flow_report_index_001 ON parking_car_flow_report (report_date);

-- version 849 cs 
CREATE SEQUENCE parking_car_flow_report_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 850 cs
CREATE TABLE IF NOT EXISTS parking_jdbc_test(
	id bigint NOT NULL,
    test varchar(100),
    PRIMARY KEY (id)
);

-- version 851 cs
ALTER TABLE parking_discount_record ADD COLUMN free_money decimal(30,2);

-- version 852 cs
ALTER TABLE parking_discount_record ADD COLUMN in_out smallint;

-- version 853 cs
ALTER TABLE parking_discount_record ADD COLUMN palte_number varchar(50);

-- version 854 cs
ALTER TABLE parking_discount_record ADD COLUMN discount_source varchar(50);

-- version 855 cs
ALTER TABLE parking_discount_record ADD COLUMN passport_number varchar(100);

-- version 856 cs
ALTER TABLE parking_discount_record ADD COLUMN medium_type smallint;

-- version 857 cs
ALTER TABLE parking_discount_record ADD COLUMN passport_type_id integer;

-- version 858 cs
ALTER TABLE parking_discount_record ADD COLUMN passport_type_name varchar(100);

-- version 859 cs
ALTER TABLE parking_discount_record ADD COLUMN car_type_id integer;

-- version 860 cs
ALTER TABLE parking_discount_record ADD COLUMN car_type_name varchar(100);

-- version 861 cs
ALTER TABLE parking_discount_record ADD COLUMN computer_name varchar(100);

-- version 862 cs
CREATE INDEX parking_discount_record_index_002 ON parking_discount_record (make_time);

-- version 863 cs
CREATE TABLE IF NOT EXISTS parking_hm_pay(
	order_number varchar(64),
    parking_id varchar(100),
    msg_id varchar(100),
    created_time timestamp NOT NULL,
    product_service_id bigint,
    PRIMARY KEY (order_number)
);

-- version 864 cs
CREATE INDEX parking_car_pass_record_history_index_003 ON parking_car_pass_record_history (enter_record_id);

-- version 865 cs
CREATE TABLE IF NOT EXISTS parking_upload_cloud(
    id bigint NOT NULL,
	plate_number varchar(50) NOT NULL,
    pass_time timestamp,
    op_state char(1),
    created_time timestamp NOT NULL,
    PRIMARY KEY (id)
);

-- version 866 cs
CREATE SEQUENCE parking_upload_cloud_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 867 cs $$;
CREATE OR REPLACE FUNCTION parking_upload_cloud_data_log() RETURNS trigger LANGUAGE plpgsql AS $$
     DECLARE
     d_parking_id parking_business_strategy_sync.strategy_value%TYPE;
     BEGIN 
	    d_parking_id := NULL;
	    SELECT strategy_value INTO d_parking_id FROM parking_business_strategy_sync WHERE strategy_name='hm_cloud_parkingId' AND strategy_type=8;
	    IF (d_parking_id IS NOT NULL AND char_length(d_parking_id) > 20) THEN
	       IF TG_RELNAME = 'parking_car_pass_enter_record' THEN
		        IF TG_OP = 'INSERT' THEN 
		           IF(NEW.area_type IS NOT NULL AND NEW.area_type = 1) THEN 
		              IF (NEW.enter_time IS NOT NULL AND NEW.enter_plate IS NOT NULL AND NEW.enter_plate <> '' ) THEN 
		                  INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.enter_plate,NEW.enter_time,'0',now());
		              END IF;
		           END IF;
		        ELSIF TG_OP = 'UPDATE' THEN 
		           IF(NEW.area_type IS NOT NULL AND NEW.area_type = 1 AND OLD.area_type IS NOT NULL AND OLD.area_type = 1) THEN 
		              IF (NEW.enter_time IS NOT NULL AND NEW.enter_plate IS NOT NULL AND NEW.enter_plate <> '' AND OLD.enter_plate <> NEW.enter_plate) THEN 
		                 IF(OLD.enter_time IS NOT NULL AND OLD.enter_plate IS NOT NULL) THEN
		                    INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),OLD.enter_plate,OLD.enter_time,'1',now());
		                 END IF;
		                 INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.enter_plate,NEW.enter_time,'0',now());
		              END IF;
		           END IF;
		        END IF;
		    ELSIF TG_RELNAME = 'parking_car_pass_record_history' THEN
		        IF TG_OP = 'INSERT' THEN
		           IF(NEW.area_type IS NOT NULL AND NEW.area_type = 1) THEN 
		              IF(NEW.exit_time IS NOT NULL AND NEW.exit_plate IS NOT NULL AND NEW.exit_plate <> '') THEN 
			               INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.exit_plate,NEW.exit_time,'1',now());
			               IF(NEW.enter_plate IS NOT NULL AND NEW.enter_plate <> '' AND NEW.enter_plate <> NEW.exit_plate) THEN 
			                  INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.enter_plate,NEW.exit_time,'1',now());
			               END IF;
			          ELSIF (NEW.enter_time IS NOT NULL AND NEW.enter_plate IS NOT NULL AND NEW.enter_plate <> '' ) THEN 
			               INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.enter_plate,NEW.enter_time,'1',now());
			          END IF;
		           END IF;
		        ELSIF TG_OP = 'UPDATE' THEN 
		           IF(NEW.exit_time IS NOT NULL AND NEW.exit_plate IS NOT NULL AND NEW.exit_plate <> '' AND NEW.exit_plate <> OLD.exit_plate ) THEN
		               INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.exit_plate,NEW.exit_time,'1',now());
		           END IF;
			    END IF;
		    ELSIF TG_RELNAME = 'parking_passport_sync' THEN 
		        IF TG_OP = 'INSERT' THEN
		             IF(NEW.register_plate IS NOT NULL AND NEW.register_plate <> '' ) THEN
		                 INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.register_plate,NULL,'I',now());
		             END IF; 
		        ELSIF TG_OP = 'UPDATE' THEN
		             IF(NEW.register_plate IS NOT NULL AND NEW.register_plate <> '' AND OLD.register_plate <> NEW.register_plate) THEN 
		                IF(OLD.register_plate IS NOT NULL AND OLD.register_plate <> '') THEN
		                  INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),OLD.register_plate,NULL,'D',now());
		                END IF;
		                INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),NEW.register_plate,NULL,'I',now());
		             END IF;
		        ELSIF TG_OP = 'DELETE' THEN
		             IF(OLD.register_plate IS NOT NULL AND OLD.register_plate <> '' ) THEN 
		                 INSERT INTO parking_upload_cloud(id,plate_number,pass_time,op_state,created_time) VALUES (nextval('parking_upload_cloud_seq'),OLD.register_plate,NULL,'D',now());
		             END IF;
		        END IF;
		    END IF; 
	    END IF;
    RETURN NULL;
    END;
$$;

-- version 868 s 
DROP TRIGGER IF EXISTS parking_car_pass_enter_record_upload_trigger ON parking_car_pass_enter_record;

-- version 869 s 
CREATE TRIGGER parking_car_pass_enter_record_upload_trigger AFTER INSERT OR UPDATE ON parking_car_pass_enter_record FOR EACH ROW EXECUTE PROCEDURE parking_upload_cloud_data_log();

-- version 870 s 
DROP TRIGGER IF EXISTS parking_car_pass_record_history_upload_trigger ON parking_car_pass_record_history;

-- version 871 s 
CREATE TRIGGER parking_car_pass_record_history_upload_trigger AFTER INSERT OR UPDATE ON parking_car_pass_record_history FOR EACH ROW EXECUTE PROCEDURE parking_upload_cloud_data_log();

-- version 872 s 
DROP TRIGGER IF EXISTS parking_passport_sync_upload_trigger ON parking_passport_sync;

-- version 873 s
CREATE TRIGGER parking_passport_sync_upload_trigger AFTER INSERT OR UPDATE OR DELETE ON parking_passport_sync FOR EACH ROW EXECUTE PROCEDURE parking_upload_cloud_data_log();

-- version 874 cs
ALTER TABLE parking_role_sync ADD COLUMN role_type smallint;

-- version 875 cs
ALTER TABLE parking_discount_sync ADD COLUMN role_id integer;

-- version 876 cs
ALTER TABLE parking_discount_sync ADD COLUMN discount_free_time timestamp;

-- version 877 cs
ALTER TABLE parking_discount_record ADD COLUMN role_id integer;

-- version 878 cs
ALTER TABLE parking_discount_record ADD COLUMN discount_free_time timestamp;

-- version 879 cs
CREATE INDEX parking_discount_record_index_003 ON parking_discount_record (palte_number);

-- version 880 cs
DROP INDEX parking_discount_record_index_002;

-- version 881 cs
CREATE INDEX parking_discount_record_index_002 ON parking_discount_record (make_time,role_id);

-- version 882 cs
CREATE INDEX parking_car_pass_enter_record_index_003 ON parking_car_pass_enter_record (enter_plate);

-- version 883 cs
CREATE TABLE IF NOT EXISTS parking_discount_record_sync(
  id bigint NOT NULL,
  pass_record_id bigint,
  proj_code varchar(100),
  proj_name varchar(100),
  discount_method smallint,
  discount_time integer,
  discount_money decimal(30,2),
  discount_ratio decimal(30,2),
  free_expiration_time timestamp,
  discount_type smallint,
  discount_client_id integer,
  discount_account_id integer,
  discount_client_name varchar(100),
  pay_type smallint,
  pay_money decimal(30,2),
  number_of_work_id bigint,
  parking_id integer,
  user_code varchar(100),
  user_name varchar(100),
  make_time timestamp,
  product_service_id bigint NOT NULL,
  free_money decimal(30,2),
  in_out smallint,
  palte_number varchar(50),
  discount_source varchar(50),
  passport_number varchar(100),
  medium_type smallint,
  passport_type_id integer,
  passport_type_name varchar(100),
  car_type_id integer,
  car_type_name varchar(100),
  computer_name varchar(100),
  role_id integer,
  discount_free_time timestamp,
  last_updated_time timestamp NOT NULL,
  operation_user varchar(100) NOT NULL,
  PRIMARY KEY (id)
);

-- version 884 cs
CREATE INDEX parking_discount_record_sync_index_001 ON parking_discount_record_sync (pass_record_id);

-- version 885 cs
CREATE INDEX parking_discount_record_sync_index_002 ON parking_discount_record_sync (make_time);

-- version 886 cs
CREATE INDEX parking_discount_record_sync_index_003 ON parking_discount_record_sync (palte_number);

-- version 887 cs
DROP TRIGGER IF EXISTS parking_discount_record_sync_log_trigger ON parking_discount_record_sync;

-- version 888 s 
CREATE TRIGGER parking_discount_record_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_discount_record_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 889 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN vi_phone varchar(100);

-- version 890 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN vi_name varchar(100);

-- version 891 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN vi_company varchar(100);

-- version 892 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN vi_id varchar(100);

-- version 893 cs
ALTER TABLE parking_visitor_authorization ADD COLUMN visit_reason varchar(300);

-- version 894 cs
ALTER TABLE parking_car_pass_record ALTER COLUMN enter_channel_managed_mode TYPE integer;

-- version 895 cs
ALTER TABLE parking_car_pass_record ALTER COLUMN exit_channel_managed_mode TYPE integer;

-- version 896 cs
ALTER TABLE parking_car_pass_enter_record ALTER COLUMN enter_channel_managed_mode TYPE integer;

-- version 897 cs
ALTER TABLE parking_car_pass_enter_record ALTER COLUMN exit_channel_managed_mode TYPE integer;

-- version 898 cs
ALTER TABLE parking_car_pass_record_history ALTER COLUMN enter_channel_managed_mode TYPE integer;

-- version 899 cs
ALTER TABLE parking_car_pass_record_history ALTER COLUMN exit_channel_managed_mode TYPE integer;   

-- version 900 cs 
CREATE TABLE IF NOT EXISTS parking_disptch_car_sync(
   id integer NOT NULL,
   plate_number varchar(50) NOT NULL,
   enter_time timestamp NULL,
   exit_time timestamp NULL,
   exit_expire_date timestamp,
   sms_notify smallint NOT NULL,
   sms_phone_number varchar(300) NULL,
   sms_car_leave smallint NULL,
   sms_car_back smallint NULL,
   sms_car_not_back smallint NULL,
   sms_car_not_back_time timestamp,
   attribute1 varchar(200) NULL,
   attribute2 varchar(200) NULL,
   attribute3 varchar(200) NULL,
   attribute4 varchar(200) NULL,
   attribute5 varchar(200) NULL,
   attribute6 varchar(200) NULL,
   attribute7 varchar(200) NULL,
   attribute8 varchar(200) NULL,
   attribute9 varchar(200) NULL,
   attribute10 varchar(200) NULL,
   attribute11 varchar(200) NULL,
   attribute12 varchar(200) NULL,
   attribute13 varchar(200) NULL,
   attribute14 varchar(200) NULL,
   attribute15 varchar(200) NULL,
   attribute16 varchar(200) NULL,
   attribute17 varchar(200) NULL,
   attribute18 varchar(200) NULL,
   attribute19 varchar(200) NULL,
   attribute20 varchar(200) NULL,
   attribute21 varchar(200) NULL,
   attribute22 varchar(200) NULL,
   attribute23 varchar(200) NULL,
   attribute24 varchar(200) NULL,
   attribute25 varchar(200) NULL,
   attribute26 varchar(200) NULL,
   attribute27 varchar(200) NULL,
   attribute28 varchar(200) NULL,
   attribute29 varchar(200) NULL,
   attribute30 varchar(200) NULL,
   attribute31 varchar(200) NULL,
   attribute32 varchar(200) NULL,
   attribute33 varchar(200) NULL,
   attribute34 varchar(200) NULL,
   attribute35 varchar(200) NULL,
   attribute36 varchar(200) NULL,
   attribute37 varchar(200) NULL,
   attribute38 varchar(200) NULL,
   attribute39 varchar(200) NULL,
   attribute40 varchar(200) NULL,
   attribute41 varchar(200) NULL,
   attribute42 varchar(200) NULL,
   attribute43 varchar(200) NULL,
   attribute44 varchar(200) NULL,
   attribute45 varchar(200) NULL,
   attribute46 varchar(200) NULL,
   attribute47 varchar(200) NULL,
   attribute48 varchar(200) NULL,
   attribute49 varchar(200) NULL,
   attribute50 varchar(200) NULL,
   dispatch_state smallint NOT NULL DEFAULT 0,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 901 cs 
CREATE INDEX parking_disptch_car_sync_index_001 ON parking_disptch_car_sync (plate_number,dispatch_state);

-- version 903 cs
CREATE INDEX parking_disptch_car_sync_index_003 ON parking_disptch_car_sync (created_time);

-- version 904 cs 
CREATE SEQUENCE parking_disptch_car_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 905 cs
DROP TRIGGER IF EXISTS parking_disptch_car_sync_log_trigger ON parking_disptch_car_sync;

-- version 906 s 
CREATE TRIGGER parking_disptch_car_sync_log_trigger AFTER INSERT OR DELETE OR UPDATE ON parking_disptch_car_sync FOR EACH ROW EXECUTE PROCEDURE parking_insert_sync_log();

-- version 907 cs 
ALTER TABLE parking_disptch_car_sync ADD COLUMN enter_expire_date timestamp;

-- version 908 cs
CREATE TABLE IF NOT EXISTS parking_sms_send_task(
   id bigint NOT NULL,
   task_no varchar(100) NOT NULL,
   plate_number varchar(50),
   send_phone_number varchar(50) NOT NULL,
   send_message varchar(300) NOT NULL,
   send_time timestamp,
   send_state smallint NOT NULL, 
   failure_reason varchar(300),
   message_des varchar(300),
   created_time timestamp NOT NULL, 
   valid_time timestamp NOT NULL, 
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 909 cs
CREATE INDEX parking_sms_send_task_index_001 ON parking_sms_send_task (task_no);

-- version 910 cs
CREATE INDEX parking_sms_send_task_index_002 ON parking_sms_send_task (valid_time,send_state);

-- version 911 cs 
CREATE SEQUENCE parking_sms_send_task_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 912 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN dispatch_car_id integer;

-- version 913 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN dispatch_car_id integer;

-- version 914 cs
ALTER TABLE parking_car_pass_record ADD COLUMN dispatch_car_id integer;

-- version 915 cs
ALTER TABLE parking_disptch_car_sync ADD COLUMN order_number varchar(100);

-- version 916 cs
CREATE TABLE IF NOT EXISTS parking_app_query_fee_log(
   id bigint NOT NULL,
   plate_number varchar(50) NOT NULL,
   app_name varchar(50),
   enter_record_id bigint,
   enter_time timestamp,
   should_fee numeric(30,2),
   discount_fee numeric(30,2),
   already_paid numeric(30,2),
   actual_fee numeric(30,2),
   fee_len integer,
   end_time timestamp,
   created_time timestamp NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 917 cs
CREATE SEQUENCE parking_app_query_fee_log_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 918 cs
CREATE INDEX parking_app_query_fee_log_index_001 ON parking_app_query_fee_log (plate_number,created_time);

-- version 919 cs
ALTER TABLE parking_client_sync ALTER COLUMN phone_number TYPE varchar(200);

-- version 920 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN phone_number varchar(200);

-- version 921 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN phone_number varchar(200);

-- version 922 cs
ALTER TABLE parking_car_pass_record ADD COLUMN phone_number varchar(200);

-- version 923 cs
ALTER TABLE parking_disptch_car_sync ADD COLUMN area_id integer;

-- version 924 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN discount_proj_code varchar(100);

-- version 925 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN discount_proj_code varchar(100);

-- version 926 cs
ALTER TABLE parking_car_pass_record ADD COLUMN discount_proj_code varchar(100);

-- version 927 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN discount_role_id integer;

-- version 928 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN discount_role_id integer;

-- version 929 cs
ALTER TABLE parking_car_pass_record ADD COLUMN discount_role_id integer;

-- version 930 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN discount_proj_name varchar(100);

-- version 931 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN discount_proj_name varchar(100);

-- version 932 cs
ALTER TABLE parking_car_pass_record ADD COLUMN discount_proj_name varchar(100);

-- version 933 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN discount_role_name varchar(100);

-- version 934 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN discount_role_name varchar(100);

-- version 935 cs
ALTER TABLE parking_car_pass_record ADD COLUMN discount_role_name varchar(100);

-- version 935 cs
ALTER TABLE parking_car_pass_record ADD COLUMN discount_role_name varchar(100);

-- version 936 cs
ALTER TABLE parking_fee_sef_record_messge ADD COLUMN self_client_type varchar(100);

-- version 937 cs
ALTER TABLE parking_fee_sef_record ADD COLUMN self_client_type varchar(100);

-- version 938 cs
ALTER TABLE parking_passport_sync ADD COLUMN obu smallint;

-- version 939 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN obu smallint;

-- version 940 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN stop_date timestamp;

-- version 941 cs
ALTER TABLE parking_passport_sync ADD COLUMN stop_date timestamp;

-- version 942 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN valid_date timestamp;

-- version 943 cs
ALTER TABLE parking_passport_sync ADD COLUMN valid_date timestamp;

-- version 944 cs
CREATE TABLE IF NOT EXISTS parking_coupon_main(
   id integer NOT NULL,
   role_id integer NOT NULL,
   role_name varchar(100),
   discount_id integer NOT NULL,
   discount_name varchar(100),
   discount_des varchar(300),
   coupon_count integer NOT NULL,
   pay_money numeric(30,2),
   valid_date timestamp,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   operation_user_name varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   PRIMARY KEY (id)
);

-- version 945 cs 
CREATE SEQUENCE parking_coupon_main_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 946 cs
CREATE INDEX parking_coupon_main_index_001 ON parking_coupon_main (created_time,role_id);

-- version 947 cs
CREATE TABLE IF NOT EXISTS parking_coupon(
   id integer NOT NULL,
   role_id integer NOT NULL,
   coupon_main_id integer NOT NULL,
   discount_id integer NOT NULL,
   discount_name varchar(100),
   discount_des varchar(300),
   valid_date timestamp NOT NULL,
   use_plate varchar(50),
   use_user varchar(100),
   use_user_name varchar(100),
   use_time timestamp,
   use_state smallint NOT NULL,
   use_state_type smallint NOT NULL,
   enter_record_id bigint,
   created_time timestamp NOT NULL,
   last_updated_time timestamp NOT NULL,
   operation_user varchar(100) NOT NULL,
   operation_user_name varchar(100) NOT NULL,
   product_service_id bigint NOT NULL,
   discount_method smallint,
   discount_time integer,
   discount_money numeric(30,2),
   discount_ratio numeric(30,2),
   discount_free_time timestamp,
   PRIMARY KEY (id)
);

-- version 948 cs 
CREATE SEQUENCE parking_coupon_seq INCREMENT BY 1 MINVALUE 10001 MAXVALUE 2147483647 START WITH 10001 CACHE 1 CYCLE;

-- version 949 cs
CREATE INDEX parking_coupon_index_001 ON parking_coupon (coupon_main_id);

-- version 950 cs
CREATE TABLE IF NOT EXISTS parking_coupon_queue(
    id integer NOT NULL,
    role_id integer NOT NULL,
    coupon_main_id integer NOT NULL,
    valid_date timestamp NOT NULL,
    discount_id integer NOT NULL,
    exe_state smallint NOT NULL,
    exe_time timestamp NOT NULL,
    PRIMARY KEY (id)
);

-- version 951 cs
CREATE INDEX parking_coupon_queue_index_001 ON parking_coupon_queue (role_id,valid_date);

-- version 952 cs
CREATE INDEX parking_coupon_index_002 ON parking_coupon (role_id,created_time);

-- version 953 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN online_pay smallint;

-- version 954 cs
ALTER TABLE parking_passport_sync ADD COLUMN online_pay smallint;

-- version 10955 cs
CREATE TABLE IF NOT EXISTS parking_etc_black_sync(
	id bigint NOT NULL,
    ic_card_no varchar(64) NOT NULL,
    gen_cau varchar(45),
    gen_date date,
    psam_issuer smallint NOT NULL,
    cloud_id bigint NOT NULL,
    create_date date NOT NULL,
    last_updated_time timestamp NOT NULL,
    operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);

-- version 10956 cs
CREATE INDEX parking_etc_black_sync_index_001 ON parking_etc_black_sync (ic_card_no);

-- version 10957 cs
CREATE INDEX parking_etc_black_sync_index_002 ON parking_etc_black_sync (cloud_id);

-- version 10958 cs 
CREATE SEQUENCE parking_etc_black_sync_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 9223372036854775807 START WITH 1 CACHE 1 CYCLE;

-- version 10959 cs
CREATE TABLE IF NOT EXISTS parking_sync_cloud_data(
	id integer NOT NULL,
    table_name varchar(64) NOT NULL,
    sync_data_type varchar(64) NOT NULL,
    last_sync_log_id bigint NOT NULL,
    last_updated_time timestamp NOT NULL,
    operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);

-- version 10960 cs
CREATE INDEX parking_sync_cloud_data_index_001 ON parking_sync_cloud_data (table_name,sync_data_type);

-- version 10961 cs 
CREATE SEQUENCE parking_sync_cloud_data_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 10962 cs 
CREATE TABLE IF NOT EXISTS parking_yuetong_tran_record(
	id bigint NOT NULL,
    enter_record_id bigint NOT NULL,
    plate_number varchar(20), 
    obu_id varchar(16) NOT NULL,
    ic_code varchar(32) NOT NULL,
    ic_type varchar(10) NOT NULL,
    enter_des varchar(45) NOT NULL,
    enter_time timestamp NOT NULL,
    exit_des varchar(45) NOT NULL,
    exit_time timestamp NOT NULL,
    exp_type varchar(10) NOT NULL,
    transaction_money decimal(20,2) NOT NULL,
    transaction_time timestamp NOT NULL,
    card_blance decimal(20,2) NOT NULL,
    tr_seq varchar(32) NOT NULL,
    term_code varchar(32) NOT NULL,
    term_seq varchar(32) NOT NULL,
    tac_code varchar(32) NOT NULL,
    last_updated_time timestamp NOT NULL,
    operation_user varchar(100) NOT NULL,
	product_service_id bigint NOT NULL,
    PRIMARY KEY (id)
);

-- version 10963 cs 
CREATE SEQUENCE parking_yuetong_tran_record_seq INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START WITH 1 CACHE 1 CYCLE;

-- version 10964 cs 
ALTER TABLE parking_discount_record ADD COLUMN coupon_code varchar(45);

-- version 10965 cs 
ALTER TABLE parking_discount_record_sync ADD COLUMN coupon_code varchar(45);

-- version 10966 cs 
ALTER TABLE parking_charge_record ADD COLUMN enter_record_id bigint;

-- version 10967 cs 
ALTER TABLE parking_charge_record ADD COLUMN enter_time timestamp;

-- version 10968 cs
CREATE INDEX parking_charge_record_index_002 ON parking_charge_record (pass_record_id);

-- version 10969 cs
ALTER TABLE parking_transaction_record ADD COLUMN total_money decimal(12,2);

-- version 10970 cs
ALTER TABLE parking_transaction_record ADD COLUMN discount_money decimal(12,2) DEFAULT 0.00;

-- version 10971 cs
ALTER TABLE parking_passport_sync ADD COLUMN car_pic_path varchar(300);

-- version 10972 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN car_pic_path varchar(300);

-- version 10973 cs
ALTER TABLE parking_passport_sync ADD COLUMN car_plate_pic_path varchar(300);

-- version 10974 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN car_plate_pic_path varchar(300);

-- version 10975 cs
ALTER TABLE parking_passport_sync ADD COLUMN insurance varchar(300);

-- version 10976 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN insurance varchar(300);

-- version 10977 cs
ALTER TABLE parking_passport_sync ADD COLUMN car_plate_color varchar(50);

-- version 10978 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN car_plate_color varchar(50);

-- version 10979 cs
ALTER TABLE parking_client_sync ADD COLUMN house_code varchar(100);

-- version 10980 cs
ALTER TABLE parking_client_sync ADD COLUMN house_name varchar(200);

-- version 10981 cs
ALTER TABLE parking_client_sync ADD COLUMN household_code varchar(45);

-- version 10982 cs
ALTER TABLE parking_client_sync ADD COLUMN household_name varchar(45);

-- version 10983 cs
ALTER TABLE parking_passport_sync ADD COLUMN update_plate_time timestamp;

-- version 10984 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN update_plate_time timestamp;

-- version 10985 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN auto_lock smallint;

-- version 10986 cs
ALTER TABLE parking_passport_sync ADD COLUMN auto_lock smallint;

-- version 10987 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN car_logo varchar(50);

-- version 10989 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN car_logo varchar(50);

-- version 10990 cs
ALTER TABLE parking_car_pass_record ADD COLUMN car_logo varchar(50);

-- version 10991 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN car_color varchar(50);

-- version 10992 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN car_color varchar(50);

-- version 10993 cs
ALTER TABLE parking_car_pass_record ADD COLUMN car_color varchar(50);

-- version 10994 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN reg_plate_type varchar(50);

-- version 10995 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN reg_plate_type varchar(50);

-- version 10996 cs
ALTER TABLE parking_car_pass_record ADD COLUMN reg_plate_type varchar(50);

-- version 10997 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN reg_source smallint;

-- version 10998 cs
ALTER TABLE parking_passport_sync ADD COLUMN reg_source smallint;

-- version 10999 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN car_logo varchar(50);

-- version 11000 cs
ALTER TABLE parking_passport_sync ADD COLUMN car_logo varchar(50);

-- version 11001 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN enter_pic_path varchar(300);

-- version 11002 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN enter_pic_path varchar(300);

-- version 11003 cs
ALTER TABLE parking_car_pass_record ADD COLUMN enter_pic_path varchar(300);

-- version 11004 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN exit_pic_path varchar(300);

-- version 11005 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN exit_pic_path varchar(300);

-- version 11006 cs
ALTER TABLE parking_car_pass_record ADD COLUMN exit_pic_path varchar(300);

-- version 11007 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN enter_plate_pic_path varchar(300);

-- version 11008 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN enter_plate_pic_path varchar(300);

-- version 11009 cs
ALTER TABLE parking_car_pass_record ADD COLUMN enter_plate_pic_path varchar(300);

-- version 11010 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN exit_plate_pic_path varchar(300);

-- version 11011 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN exit_plate_pic_path varchar(300);

-- version 11012 cs
ALTER TABLE parking_car_pass_record ADD COLUMN exit_plate_pic_path varchar(300);

-- version 11013 cs
ALTER TABLE parking_passport_sync ADD COLUMN reg_car_color varchar(50);

-- version 11014 cs
ALTER TABLE parking_passport_sync_backup ADD COLUMN reg_car_color varchar(50);

-- version 11015 cs
ALTER TABLE parking_special_pass_record ADD COLUMN pic_path varchar(300);

-- version 11016 cs
ALTER TABLE parking_illegal_pass_record ADD COLUMN pic_path varchar(300);

-- version 11017 cs
ALTER TABLE parking_transaction_record ADD COLUMN tran_type smallint;

-- version 11018 cs
ALTER TABLE parking_car_pass_enter_record ADD COLUMN alipay_sec char(1);

-- version 11019 cs
ALTER TABLE parking_car_pass_record_history ADD COLUMN alipay_sec char(1);

-- version 11020 cs
ALTER TABLE parking_car_pass_record ADD COLUMN alipay_sec char(1);

-- version 11021 cs
ALTER TABLE parking_app_query_fee_log ADD COLUMN period_charge varchar(500);

-- version 11022 cs 
CREATE INDEX parking_regplate_record_index_002 ON parking_regplate_record (pass_time);

-- version 11023 cs 
CREATE TABLE IF NOT EXISTS parking_car_pass_cancel_record(
  id bigint NOT NULL,
  enter_record_id bigint,
  exit_record_id bigint,
  passport_id integer,
  passport_number varchar(100),
  medium_type smallint,
  passport_type_id integer,
  passport_type_name varchar(100),
  client_id integer,
  client_name varchar(100),
  parking_id integer,
  parking_name varchar(100),
  area_id integer,
  area_type smallint,
  area_level smallint,
  area_name varchar(100),
  pass_time timestamp,
  pass_plate varchar(50),
  pass_channel_id integer,
  pass_channel_name varchar(100),
  pass_direction smallint,
  enter_time timestamp,
  enter_channel_id integer,
  enter_channel_name varchar(100),
  enter_car_type_code integer,
  enter_pay numeric(30,2),
  enter_prepay numeric(30,2),
  enter_plate varchar(50),
  enter_plate_source smallint,
  enter_obu_plate varchar(50),
  enter_reg_plate varchar(50),
  enter_number_of_work_id bigint,
  enter_user_code varchar(100),
  enter_user_name varchar(100),
  enter_lan_state smallint,
  enter_computer_name varchar(100),
  enter_pass_value smallint,
  enter_channel_managed_mode integer,
  enter_remark1 varchar(50),
  enter_remark2 varchar(50),
  enter_remark3 varchar(100),
  enter_remark4 varchar(200),
  enter_remark5 varchar(300),
  exit_time timestamp,
  exit_channel_id integer,
  exit_channel_name varchar(100),
  exit_car_type_code integer,
  exit_plate varchar(50),
  exit_plate_source smallint,
  exit_obu_plate varchar(50),
  exit_reg_plate varchar(50),
  exit_number_of_work_id bigint,
  exit_user_code varchar(100),
  exit_user_name varchar(100),
  exit_lan_state smallint,
  exit_computer_name varchar(100),
  exit_pass_value smallint,
  exit_channel_managed_mode integer,
  exit_remark1 varchar(50),
  exit_remark2 varchar(50),
  exit_remark3 varchar(100),
  exit_remark4 varchar(200),
  exit_remark5 varchar(300),
  exit_parking_time_length integer,
  exit_fee_time_length integer,
  exit_should_charge numeric(30,2),
  exit_practice_charge numeric(30,2),
  certificate_capture smallint,
  card_charge numeric(30,2),
  charge_method smallint,
  deduct_money numeric(30,2),
  cash numeric(30,2),
  cost_times integer,
  discount_money numeric(30,2),
  and_pay numeric(30,2),
  fee_comment varchar(1000),
  created_time timestamp,
  last_updated_time timestamp,
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  parking_space_type smallint,
  enter_plate_color varchar(32),
  exit_plate_color varchar(32),
  enter_car_type_name varchar(100),
  exit_car_type_name varchar(100),
  app_paid_description varchar(300),
  app_paid_time timestamp,
  app_paid_type smallint,
  app_paid_amount numeric(30,2),
  passport_balance numeric(30,2),
  passport_number_times integer,
  deadline timestamp,
  account_balance numeric(30,2),
  dispatch_car_id integer,
  phone_number varchar(200),
  discount_proj_code varchar(100),
  discount_role_id integer,
  discount_proj_name varchar(100),
  discount_role_name varchar(100),
  car_logo varchar(50),
  car_color varchar(50),
  reg_plate_type varchar(50),
  enter_pic_path varchar(300),
  exit_pic_path varchar(300),
  enter_plate_pic_path varchar(300),
  exit_plate_pic_path varchar(300),
  alipay_sec character(1),
  PRIMARY KEY (id)
);

-- version 11024 cs 
CREATE INDEX parking_car_pass_cancel_record_index_001 ON parking_car_pass_cancel_record (created_time);

-- version 11025 cs 
ALTER TABLE parking_fee_sef_record_messge ADD COLUMN period_charge varchar(500);

-- version 11026 cs 
ALTER TABLE parking_fee_sef_record ADD COLUMN period_charge varchar(500);

-- version 11027 cs 
ALTER TABLE parking_fee_sef_record ADD COLUMN cloud_order_no varchar(64);

-- version 11028 cs 
ALTER TABLE parking_fee_sef_record_messge ADD COLUMN cloud_order_no varchar(64);

-- version 11029 cs 
CREATE TABLE IF NOT EXISTS parking_car_pass_enter_record_temp(
  id bigint NOT NULL,
  enter_record_id bigint,
  exit_record_id bigint,
  passport_id integer,
  passport_number varchar(100),
  medium_type smallint,
  passport_type_id integer,
  passport_type_name varchar(100),
  client_id integer,
  client_name varchar(100),
  parking_id integer,
  parking_name varchar(100),
  area_id integer,
  area_type smallint,
  area_level smallint,
  area_name varchar(100),
  pass_time timestamp,
  pass_plate varchar(50),
  pass_channel_id integer,
  pass_channel_name varchar(100),
  pass_direction smallint,
  enter_time timestamp,
  enter_channel_id integer,
  enter_channel_name varchar(100),
  enter_car_type_code integer,
  enter_pay numeric(30,2),
  enter_prepay numeric(30,2),
  enter_plate varchar(50),
  enter_plate_source smallint,
  enter_obu_plate varchar(50),
  enter_reg_plate varchar(50),
  enter_number_of_work_id bigint,
  enter_user_code varchar(100),
  enter_user_name varchar(100),
  enter_lan_state smallint,
  enter_computer_name varchar(100),
  enter_pass_value smallint,
  enter_channel_managed_mode integer,
  enter_remark1 varchar(50),
  enter_remark2 varchar(50),
  enter_remark3 varchar(100),
  enter_remark4 varchar(200),
  enter_remark5 varchar(300),
  exit_time timestamp,
  exit_channel_id integer,
  exit_channel_name varchar(100),
  exit_car_type_code integer,
  exit_plate varchar(50),
  exit_plate_source smallint,
  exit_obu_plate varchar(50),
  exit_reg_plate varchar(50),
  exit_number_of_work_id bigint,
  exit_user_code varchar(100),
  exit_user_name varchar(100),
  exit_lan_state smallint,
  exit_computer_name varchar(100),
  exit_pass_value smallint,
  exit_channel_managed_mode integer,
  exit_remark1 varchar(50),
  exit_remark2 varchar(50),
  exit_remark3 varchar(100),
  exit_remark4 varchar(200),
  exit_remark5 varchar(300),
  exit_parking_time_length integer,
  exit_fee_time_length integer,
  exit_should_charge numeric(30,2),
  exit_practice_charge numeric(30,2),
  certificate_capture smallint,
  card_charge numeric(30,2),
  charge_method smallint,
  deduct_money numeric(30,2),
  cash numeric(30,2),
  cost_times integer,
  discount_money numeric(30,2),
  and_pay numeric(30,2),
  fee_comment varchar(1000),
  created_time timestamp,
  last_updated_time timestamp,
  operation_user varchar(100),
  product_service_id bigint NOT NULL,
  parking_space_type smallint,
  enter_plate_color varchar(32),
  exit_plate_color varchar(32),
  enter_car_type_name varchar(100),
  exit_car_type_name varchar(100),
  app_paid_description varchar(300),
  app_paid_time timestamp,
  app_paid_type smallint,
  app_paid_amount numeric(30,2),
  passport_balance numeric(30,2),
  passport_number_times integer,
  deadline timestamp,
  account_balance numeric(30,2),
  dispatch_car_id integer,
  phone_number varchar(200),
  discount_proj_code varchar(100),
  discount_role_id integer,
  discount_proj_name varchar(100),
  discount_role_name varchar(100),
  car_logo varchar(50),
  car_color varchar(50),
  reg_plate_type varchar(50),
  enter_pic_path varchar(300),
  exit_pic_path varchar(300),
  enter_plate_pic_path varchar(300),
  exit_plate_pic_path varchar(300),
  alipay_sec character(1),
  PRIMARY KEY (id)
);


